<?php
/*------------------------------------*\
	External Modules/Files
\*------------------------------------*/

// Load any external files you have here

/*------------------------------------*\
	Theme Support
\*------------------------------------*/

if (!isset($content_width)) {
    $content_width = 900;
}

if (function_exists('add_theme_support')) {
    // Add Menu Support
    add_theme_support('menus');

    // Add Thumbnail Theme Support
    add_theme_support('post-thumbnails');
    add_image_size('large', 1200, '', true); // Large Thumbnail
    add_image_size('medium', 600, '', true); // Medium Thumbnail
    add_image_size('small', 300, '', true); // Small Thumbnail
    //add_image_size('custom-size', 700, 200, true); // Custom Thumbnail Size call using the_post_thumbnail('custom-size');

    // Add Support for Custom Backgrounds - Uncomment below if you're going to use
    /*add_theme_support('custom-background', array(
	'default-color' => 'FFF',
	'default-image' => get_template_directory_uri() . '/img/bg.jpg'
    ));*/

    // Add Support for Custom Header - Uncomment below if you're going to use
    /*add_theme_support('custom-header', array(
	'default-image'			=> get_template_directory_uri() . '/img/headers/default.jpg',
	'header-text'			=> false,
	'default-text-color'		=> '000',
	'width'				=> 1000,
	'height'			=> 198,
	'random-default'		=> false,
	'wp-head-callback'		=> $wphead_cb,
	'admin-head-callback'		=> $adminhead_cb,
	'admin-preview-callback'	=> $adminpreview_cb
    ));*/

    // Enables post and comment RSS feed links to head
    add_theme_support('automatic-feed-links');

    // Localisation Support
    $resss=load_theme_textdomain('html5blank', get_template_directory() . '/languages');
    if(!is_admin(  ) && 1==2){
        if($resss){
            echo "<!-- xxxxxxxxxxxxxxxx";
            echo "DONE";
            echo "-->";
        }else{
            echo "<!-- xxxxxxxxxxxxxxxx";
            print_r(apply_filters( 'theme_locale', get_locale(), 'html5blank' ));
            echo "-->";
        }
    }
}
/*------------------------------------*\
	Functions
\*------------------------------------*/

// HTML5 Blank navigation
function html5blank_nav($_array = array())
{
    $aryy = array(
        'theme_location'  => 'header-menu',
        'menu'            => '',
        'container'       => 'div',
        'container_class' => 'menu-{menu slug}-container',
        'container_id'    => '',
        'menu_class'      => 'menu',
        'menu_id'         => '',
        'echo'            => true,
        'fallback_cb'     => 'wp_page_menu',
        'before'          => '',
        'after'           => '',
        'link_before'     => '',
        'link_after'      => '',
        'items_wrap'      => '<ul>%3$s</ul>',
        'depth'           => 0,
        'walker'          => '',
        'add_li_class'  => '',
        'add_li_has_children_class'  => '',
        'link_class' => '',
        'add_span' => '',
        'active_li_class' => ''
    );
    wp_nav_menu(array_merge($aryy, $_array));
}
function add_additional_class_on_li($classes, $item, $args)
{
    if (isset($args->add_li_class)) {
        $classes[] = $args->add_li_class;
    }

    if (in_array('menu-item-has-children', $classes) &&  isset($args->add_li_has_children_class)) {
        $classes[] = $args->add_li_has_children_class;
    }
    if (in_array('current-menu-item', $classes) &&  isset($args->active_li_class)) {
        $classes[] = $args->active_li_class;
    }
    return $classes;
}
add_filter('nav_menu_css_class', 'add_additional_class_on_li', 1, 3);
function add_menu_link_class($atts, $item, $args)
{
    if (isset($args->link_class)) {
        $atts['class'] = $args->link_class;
    }
    if (!empty($args->add_span)) {
        $item->title = '<span class="' . $args->add_span . '">' . $item->title . '</span>';
    }

    return $atts;
}
add_filter('nav_menu_link_attributes', 'add_menu_link_class', 1, 3);
// Load HTML5 Blank scripts (header.php)
function html5blank_header_scripts()
{
    if ($GLOBALS['pagenow'] != 'wp-login.php' && !is_admin()) {

        /* wp_register_script('conditionizr', get_template_directory_uri() . '/js/lib/conditionizr-4.3.0.min.js', array(), '4.3.0'); // Conditionizr
        wp_enqueue_script('conditionizr'); // Enqueue it!

        wp_register_script('modernizr', get_template_directory_uri() . '/js/lib/modernizr-2.7.1.min.js', array(), '2.7.1'); // Modernizr
        wp_enqueue_script('modernizr'); // Enqueue it! */

        wp_register_script('html5blankscripts', get_template_directory_uri() . '/js/scripts.js', array('jquery'), s_v()); // Custom scripts
        wp_enqueue_script('html5blankscripts'); // Enqueue it!
    }
}

// Load HTML5 Blank conditional scripts
function html5blank_conditional_scripts()
{
    if (is_page('pagenamehere')) {
        wp_register_script('scriptname', get_template_directory_uri() . '/js/scriptname.js', array('jquery'), s_v()); // Conditional script(s)
        wp_enqueue_script('scriptname'); // Enqueue it!
    }
}

// Load HTML5 Blank styles
function html5blank_styles()
{

    wp_register_style('html5blank', get_template_directory_uri() . '/style.css', array(), s_v(), 'all');
    wp_enqueue_style('html5blank'); // Enqueue it!

    wp_deregister_script('jquery');
    wp_enqueue_script('jquery', get_template_directory_uri() . '/orginal/jquery.js', array(), null, true);
}

// Register HTML5 Blank Navigation
function register_html5_menu()
{
    register_nav_menus(array(
        'header-menu' => __('Header Menu', 'html5blank'),
        'topbar-1-menu' => __('Top Bar Menu 1', 'html5blank'),
        'topbar-2-menu' => __('Top Bar Menu 2', 'html5blank'),
        'footer-1-menu' => __('Footer Menu 1', 'html5blank'),
        'footer-2-menu' => __('Footer Menu 2', 'html5blank'),
        'bottombar-1-menu' => __('Bottom Bar Menu', 'html5blank'),

    ));
}

// Remove the <div> surrounding the dynamic navigation to cleanup markup
function my_wp_nav_menu_args($args = '')
{
    $args['container'] = false;
    return $args;
}

// Remove Injected classes, ID's and Page ID's from Navigation <li> items
function my_css_attributes_filter($var)
{
    return is_array($var) ? array() : '';
}

// Remove invalid rel attribute values in the categorylist
function remove_category_rel_from_category_list($thelist)
{
    return str_replace('rel="category tag"', 'rel="tag"', $thelist);
}

// Add page slug to body class, love this - Credit: Starkers Wordpress Theme
function add_slug_to_body_class($classes)
{
    global $post;
    if (is_home()) {
        $key = array_search('blog', $classes);
        if ($key > -1) {
            unset($classes[$key]);
        }
    } elseif (is_page()) {
        $classes[] = sanitize_html_class($post->post_name);
    } elseif (is_singular()) {
        $classes[] = sanitize_html_class($post->post_name);
    }

    return $classes;
}

// If Dynamic Sidebar Exists
if (function_exists('register_sidebar')) {
    // Define Sidebar Widget Area 1
    register_sidebar(array(
        'name' => __('Widget Area 1', 'html5blank'),
        'description' => __('Description for this widget-area...', 'html5blank'),
        'id' => 'widget-area-1',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));

    // Define Sidebar Widget Area 2
    register_sidebar(array(
        'name' => __('Widget Area 2', 'html5blank'),
        'description' => __('Description for this widget-area...', 'html5blank'),
        'id' => 'widget-area-2',
        'before_widget' => '<div id="%1$s" class="%2$s">',
        'after_widget' => '</div>',
        'before_title' => '<h3>',
        'after_title' => '</h3>'
    ));
}

// Remove wp_head() injected Recent Comment styles
function my_remove_recent_comments_style()
{
    global $wp_widget_factory;
    remove_action('wp_head', array(
        $wp_widget_factory->widgets['WP_Widget_Recent_Comments'],
        'recent_comments_style'
    ));
}

// Pagination for paged posts, Page 1, Page 2, Page 3, with Next and Previous Links, No plugin
function html5wp_pagination()
{
    global $wp_query;
    $big = 999999999;
    echo paginate_links(array(
        'base' => str_replace($big, '%#%', get_pagenum_link($big)),
        'format' => '?paged=%#%',
        'current' => max(1, get_query_var('paged')),
        'total' => $wp_query->max_num_pages
    ));
}

// Custom Excerpts
function html5wp_index($length) // Create 20 Word Callback for Index page Excerpts, call using html5wp_excerpt('html5wp_index');
{
    return 20;
}

// Create 40 Word Callback for Custom Post Excerpts, call using html5wp_excerpt('html5wp_custom_post');
function html5wp_custom_post($length)
{
    return 40;
}

// Create the Custom Excerpts callback
function html5wp_excerpt($length_callback = '', $more_callback = '')
{
    global $post;
    if (function_exists($length_callback)) {
        add_filter('excerpt_length', $length_callback);
    }
    if (function_exists($more_callback)) {
        add_filter('excerpt_more', $more_callback);
    }
    $output = get_the_excerpt();
    $output = apply_filters('wptexturize', $output);
    $output = apply_filters('convert_chars', $output);
    $output = '<p>' . $output . '</p>';
    echo $output;
}

// Custom View Article link to Post
function html5_blank_view_article($more)
{
    global $post;
    return '... <a class="view-article" href="' . get_permalink($post->ID) . '">' . __('View Article', 'html5blank') . '</a>';
}

// Remove Admin bar
function remove_admin_bar()
{
    return false;
}

// Remove 'text/css' from our enqueued stylesheet
function html5_style_remove($tag)
{
    return preg_replace('~\s+type=["\'][^"\']++["\']~', '', $tag);
}

// Remove thumbnail width and height dimensions that prevent fluid images in the_thumbnail
function remove_thumbnail_dimensions($html)
{
    $html = preg_replace('/(width|height)=\"\d*\"\s/', "", $html);
    return $html;
}

// Custom Gravatar in Settings > Discussion
function html5blankgravatar($avatar_defaults)
{
    $myavatar = get_template_directory_uri() . '/img/gravatar.jpg';
    $avatar_defaults[$myavatar] = "Custom Gravatar";
    return $avatar_defaults;
}

// Threaded Comments
function enable_threaded_comments()
{
    if (!is_admin()) {
        if (is_singular() and comments_open() and (get_option('thread_comments') == 1)) {
            wp_enqueue_script('comment-reply');
        }
    }
}

// Custom Comments Callback
function html5blankcomments($comment, $args, $depth)
{
    $GLOBALS['comment'] = $comment;
    extract($args, EXTR_SKIP);

    if ('div' == $args['style']) {
        $tag = 'div';
        $add_below = 'comment';
    } else {
        $tag = 'li';
        $add_below = 'div-comment';
    }
?>
    <!-- heads up: starting < for the html tag (li or div) in the next line: -->
    <<?php echo $tag ?> <?php comment_class(empty($args['has_children']) ? '' : 'parent') ?> id="comment-<?php comment_ID() ?>">
        <?php if ('div' != $args['style']) : ?>
            <div id="div-comment-<?php comment_ID() ?>" class="comment-body">
            <?php endif; ?>
            <div class="comment-author vcard">
                <?php if ($args['avatar_size'] != 0) echo get_avatar($comment, $args['180']); ?>
                <?php printf(__('<cite class="fn">%s</cite> <span class="says">says:</span>'), get_comment_author_link()) ?>
            </div>
            <?php if ($comment->comment_approved == '0') : ?>
                <em class="comment-awaiting-moderation"><?php _e('Your comment is awaiting moderation.') ?></em>
                <br />
            <?php endif; ?>

            <div class="comment-meta commentmetadata"><a href="<?php echo htmlspecialchars(get_comment_link($comment->comment_ID)) ?>">
                    <?php
                    printf(__('%1$s at %2$s'), get_comment_date(),  get_comment_time()) ?></a><?php edit_comment_link(__('(Edit)'), '  ', '');
                                                                                        ?>
            </div>

            <?php comment_text() ?>

            <div class="reply">
                <?php comment_reply_link(array_merge($args, array('add_below' => $add_below, 'depth' => $depth, 'max_depth' => $args['max_depth']))) ?>
            </div>
            <?php if ('div' != $args['style']) : ?>
            </div>
        <?php endif; ?>
        <?php }

    /*------------------------------------*\
	Actions + Filters + ShortCodes
\*------------------------------------*/

    // Add Actions
    add_action('init', 'html5blank_header_scripts'); // Add Custom Scripts to wp_head
    add_action('wp_print_scripts', 'html5blank_conditional_scripts'); // Add Conditional Page Scripts
    add_action('get_header', 'enable_threaded_comments'); // Enable Threaded Comments
    add_action('wp_enqueue_scripts', 'html5blank_styles'); // Add Theme Stylesheet
    add_action('init', 'register_html5_menu'); // Add HTML5 Blank Menu
    add_action('init', 'create_post_type_html5'); // Add our HTML5 Blank Custom Post Type
    add_action('widgets_init', 'my_remove_recent_comments_style'); // Remove inline Recent Comment Styles from wp_head()
    add_action('init', 'html5wp_pagination'); // Add our HTML5 Pagination

    // Remove Actions
    remove_action('wp_head', 'feed_links_extra', 3); // Display the links to the extra feeds such as category feeds
    remove_action('wp_head', 'feed_links', 2); // Display the links to the general feeds: Post and Comment Feed
    remove_action('wp_head', 'rsd_link'); // Display the link to the Really Simple Discovery service endpoint, EditURI link
    remove_action('wp_head', 'wlwmanifest_link'); // Display the link to the Windows Live Writer manifest file.
    remove_action('wp_head', 'index_rel_link'); // Index link
    remove_action('wp_head', 'parent_post_rel_link', 10, 0); // Prev link
    remove_action('wp_head', 'start_post_rel_link', 10, 0); // Start link
    remove_action('wp_head', 'adjacent_posts_rel_link', 10, 0); // Display relational links for the posts adjacent to the current post.
    remove_action('wp_head', 'wp_generator'); // Display the XHTML generator that is generated on the wp_head hook, WP version
    remove_action('wp_head', 'adjacent_posts_rel_link_wp_head', 10, 0);
    remove_action('wp_head', 'rel_canonical');
    remove_action('wp_head', 'wp_shortlink_wp_head', 10, 0);

    // Add Filters
    add_filter('avatar_defaults', 'html5blankgravatar'); // Custom Gravatar in Settings > Discussion
    add_filter('body_class', 'add_slug_to_body_class'); // Add slug to body class (Starkers build)
    add_filter('widget_text', 'do_shortcode'); // Allow shortcodes in Dynamic Sidebar
    add_filter('widget_text', 'shortcode_unautop'); // Remove <p> tags in Dynamic Sidebars (better!)
    add_filter('wp_nav_menu_args', 'my_wp_nav_menu_args'); // Remove surrounding <div> from WP Navigation
    // add_filter('nav_menu_css_class', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> injected classes (Commented out by default)
    // add_filter('nav_menu_item_id', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> injected ID (Commented out by default)
    // add_filter('page_css_class', 'my_css_attributes_filter', 100, 1); // Remove Navigation <li> Page ID's (Commented out by default)
    add_filter('the_category', 'remove_category_rel_from_category_list'); // Remove invalid rel attribute
    add_filter('the_excerpt', 'shortcode_unautop'); // Remove auto <p> tags in Excerpt (Manual Excerpts only)
    add_filter('the_excerpt', 'do_shortcode'); // Allows Shortcodes to be executed in Excerpt (Manual Excerpts only)
    add_filter('excerpt_more', 'html5_blank_view_article'); // Add 'View Article' button instead of [...] for Excerpts
    add_filter('show_admin_bar', 'remove_admin_bar'); // Remove Admin bar
    add_filter('style_loader_tag', 'html5_style_remove'); // Remove 'text/css' from enqueued stylesheet
    add_filter('post_thumbnail_html', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to thumbnails
    add_filter('image_send_to_editor', 'remove_thumbnail_dimensions', 10); // Remove width and height dynamic attributes to post images

    // Remove Filters
    remove_filter('the_excerpt', 'wpautop'); // Remove <p> tags from Excerpt altogether

    // Shortcodes
    add_shortcode('html5_shortcode_demo', 'html5_shortcode_demo'); // You can place [html5_shortcode_demo] in Pages, Posts now.
    add_shortcode('html5_shortcode_demo_2', 'html5_shortcode_demo_2'); // Place [html5_shortcode_demo_2] in Pages, Posts now.

    // Shortcodes above would be nested like this -
    // [html5_shortcode_demo] [html5_shortcode_demo_2] Here's the page title! [/html5_shortcode_demo_2] [/html5_shortcode_demo]

    /*------------------------------------*\
	Custom Post Types
\*------------------------------------*/

    // Create 1 Custom Post type for a Demo, called HTML5-Blank
    function create_post_type_html5()
    {
        register_taxonomy_for_object_type('category', 'html5-blank'); // Register Taxonomies for Category
        register_taxonomy_for_object_type('post_tag', 'html5-blank');
        register_post_type(
            'html5-blank', // Register Custom Post Type
            array(
                'labels' => array(
                    'name' => __('HTML5 Blank Custom Post', 'html5blank'), // Rename these to suit
                    'singular_name' => __('HTML5 Blank Custom Post', 'html5blank'),
                    'add_new' => __('Add New', 'html5blank'),
                    'add_new_item' => __('Add New HTML5 Blank Custom Post', 'html5blank'),
                    'edit' => __('Edit', 'html5blank'),
                    'edit_item' => __('Edit HTML5 Blank Custom Post', 'html5blank'),
                    'new_item' => __('New HTML5 Blank Custom Post', 'html5blank'),
                    'view' => __('View HTML5 Blank Custom Post', 'html5blank'),
                    'view_item' => __('View HTML5 Blank Custom Post', 'html5blank'),
                    'search_items' => __('Search HTML5 Blank Custom Post', 'html5blank'),
                    'not_found' => __('No HTML5 Blank Custom Posts found', 'html5blank'),
                    'not_found_in_trash' => __('No HTML5 Blank Custom Posts found in Trash', 'html5blank')
                ),
                'public' => true,
                'hierarchical' => true, // Allows your posts to behave like Hierarchy Pages
                'has_archive' => true,
                'supports' => array(
                    'title',
                    'editor',
                    'excerpt',
                    'thumbnail'
                ), // Go to Dashboard Custom HTML5 Blank post for supports
                'can_export' => true, // Allows export in Tools > Export
                'taxonomies' => array(
                    'post_tag',
                    'category'
                ) // Add Category and Post Tags support
            )
        );
    }

    /*------------------------------------*\
	ShortCode Functions
\*------------------------------------*/

    // Shortcode Demo with Nested Capability
    function html5_shortcode_demo($atts, $content = null)
    {
        return '<div class="shortcode-demo">' . do_shortcode($content) . '</div>'; // do_shortcode allows for nested Shortcodes
    }

    // Shortcode Demo with simple <h2> tag
    function html5_shortcode_demo_2($atts, $content = null) // Demo Heading H2 shortcode, allows for nesting within above element. Fully expandable.
    {
        return '<h2>' . $content . '</h2>';
    }


    ///////////////////////////////






    add_shortcode('template-uri', function ($atts) {

        return e_url();
    });
    function e_url($echo = '')
    {
        if (empty($echo)) {
            return get_template_directory_uri();
        } else {
            echo get_template_directory_uri() . $echo;
        }
    }



    add_action('after_setup_theme', 'woocommerce_support');
    function woocommerce_support()
    {
        add_theme_support('woocommerce');
        add_theme_support('wc-product-gallery-zoom');
        add_theme_support('wc-product-gallery-lightbox');
        add_theme_support('wc-product-gallery-slider');
    }

    //////////////////////////////////////
    function allowed_pages()
    {
        return array('index.phpX', 'post.php', 'nav-menus.php', 'edit.php', 'upload.php', 'edit-tags.php', 'media-new.php', 'toplevel_page_starter_theme_options', 'woocommerce_page_wc-admin', 'woocommerce_page_wc-orders', 'woocommerce_page_wc-admin', 'woocommerce_page_wc-reports', 'woocommerce_page_wc-settings', 'woocommerce_page_wc-status', 'post-new.php', 'product_page_product_attributes', 'product_page_product-reviews', 'profile.php');
    }
    add_action('admin_enqueue_scripts', function ($page) {
        echo "<!--$page-->";
        if (!empty($_GET['test_page'])) {
            return;
        }
        global $current_user;

        $user_roles = $current_user->roles;
        $user_role = array_shift($user_roles);
        $allowed = allowed_pages();
        if (($user_role == 'plan_c' && !in_array($page, $allowed)) || $page=='index.php') {
                if (class_exists('WooCommerce')) {
                    $userRedirect = 'edit.php?post_type=product';
                } else {
                    $userRedirect = 'edit.php?post_type=page';
                }

                $url = admin_url($userRedirect);
                wp_safe_redirect($url);
                exit();
                die('');
        }
    });

    add_action('admin_footer',  function () {
        //echo get_user_meta(get_current_user_id(  ), 'starter_user_level', true);
        global $current_user;

        $user_roles = $current_user->roles;
        $user_role = array_shift($user_roles);
        if ($user_role == 'plan_c') {

        ?>

            <style>
                ul#adminmenu>li:not(#collapse-menu, #menu-users, #menu-posts, #menu-media, #toplevel_page_starter_theme_options, #menu-pages, #menu-posts-product, #toplevel_page_woocommerce) {
                    display: none;
                    opacity: 0.2;
                }


                [aria-controls="screen-options-wrap"] {
                    display: none !important;
                }

                body:not(.woocommerce-admin-pageXX) .wrap>*:not(div#nav-menus-frame, #posts-filter, #col-container, .media-frame, #file-form, #wc-orders-filter, #root, .nav-tab-wrapper, .subsubsub, .clear, #poststuff, .wc_status_table, a, .woocommerce-BlankState, #mainform, form#your-profile) {
                    display: none !important;
                    opacity: 0.2;
                }

                .wrap #message,
                .wrap .woocommerce-message {
                    display: none !important;
                }
            </style>
        <?php
        }
    });

    ///////////////////////////////////////
    add_action('admin_menu', 'change_media_label');

    function change_media_label()
    {
        global $menu, $submenu;
        // $allowed=allowed_pages();
        foreach ($menu as $ky => $_menu) {
            /*  if( !in_array($_menu[2],$allowed)){
        remove_menu_page($_menu[2]);
    } */
            $menu[$ky][0] = str_replace('WooCommerce', 'Shop', ($menu[$ky][0]));
            $menu[$ky][0] = str_replace('Posts', 'Blog', ($menu[$ky][0]));
            $menu[$ky][0] = str_replace('Media', 'Images&Videos', ($menu[$ky][0]));
        }
        /* $menu[10][0] = 'Photos/Videos';
  $submenu['upload.php'][5][0] = 'All Photos/Videos';
  $submenu['upload.php'][10][0] = 'Upload new'; */
    }

    /////////
    function main_uri($_add = "")
    {
        if (!empty($_add)) {
            echo get_stylesheet_directory_uri() . $_add;
        }
        return get_stylesheet_directory_uri();
    }
    ////////////////////////////////////////
    add_action('woocommerce_before_subcategory', function () {
        echo "<div class='cat_image_parent'>";
    });
    add_action('woocommerce_before_subcategory_title', function () {
        echo "</div>";
    });
    /////////////////////
    function content_wraper($before = true)
    {
        if ($before) {
            $clss = "";
            if (is_single() || is_page()) {
                $clss = get_post_meta(get_queried_object_id(), 'starter_body_style', true);
            }
            echo '<div id="main-content-parent" class="container py-5 my-1 ' . $clss . '">
	<div id="main-content">	';
        } else {

            echo '</div>
</div>';
        }
    }
    function starter_textdoamin($str, $domain = 'html5blank')
    {
        return __($str, $domain);
    }
    ///////////////////////
    function s_v()
    {
        return '?v=1.1.3';
    }
    //////////////////////

    add_action('login_head', function () {
        $src = get_bloginfo('template_url') . '/images/logo.png';
        $user_logo = get_option('starter_site_logo');
        if (!empty($user_logo)) {
            $src = wp_get_attachment_image_url($user_logo, 'medium');
        };
        ?>
        <style type="text/css">
            body {
                background: #e9f9ff;

            }

            .login form {
                background: #bdecff;
            }

            h1 a {
                background-image: url(<?= $src ?>) !important;
                background-position: center !important;
            }

            #login {
                width: 90%;
                max-width: 500px;
            }
        </style>
    <?php
    });


    add_filter('login_headerurl', function () {
        return get_bloginfo('url');
    });

    add_filter('login_headertitle', function () {
        return get_bloginfo('name');
    });
    add_action('after_switch_theme', function () {
        if (isset($_GET['activated']) && get_current_theme() == 'WS Starter') {
            wp_safe_redirect(admin_url('admin.php?page=starter_theme_options'));
            exit;
        }
    });
///////////////////////////
/* add_filter( 'gettext',function ( $text ) {

    //$text = str_ireplace( 'Registration complete. Please check your email, then visit the', ' Custom Message',  $text );
    $text.='XX';
    return $text;
}); */
/* add_filter( 'the_title',function ( $text ) {

    //$text = str_ireplace( 'Registration complete. Please check your email, then visit the', ' Custom Message',  $text );

    return '('.__(ucwords($text)).')';
},1,10); */

    //////////////////////////////
    include_once "templates.php";
    include_once "eh-block-editor.php";
    include "eh_theme_options.php";
    include "first_run.php";
    include "woocommerce_functions.php";
    include "user_profile.php";

    ?>