import { createRoot } from '@wordpress/element';
import { registerPlugin } from '@wordpress/plugins';
import '@page-creator/app.css';
import { MainButton } from '@page-creator/components/MainButton';
import { Modal } from '@page-creator/components/Modal';

const isPageCreatorEnabled = () => {
	return (
		window.extSharedData?.isLaunchCompleted &&
		window.extSharedData?.aiPageCreatorEnabled &&
		window.wp.data.select('core/editor').getCurrentPostType() === 'page'
	);
};

registerPlugin('extendify-page-creator', {
	render: () => {
		// We will only enable it if Launch was completed.
		if (!isPageCreatorEnabled()) return;

		if (typeof createRoot !== 'function') return;
		const id = 'extendify-page-creator-btn';
		const className = 'extendify-page-creator';
		const page = '.edit-post-header-toolbar';
		const fse = '.edit-site-header-edit-mode__start';
		if (!document.querySelector(page) && !document.querySelector(fse)) {
			return;
		}
		requestAnimationFrame(() => {
			if (document.getElementById(id)) return;
			const btnWrap = document.createElement('div');
			const btn = Object.assign(btnWrap, { id, className });
			document.querySelector(page)?.append(btn);
			document.querySelector(fse)?.append(btn);
			createRoot(btn).render(<MainButton />);

			const mdl = 'extendify-page-creator-modal';
			if (document.getElementById(mdl)) return;
			const modalWrap = document.createElement('div');
			const modal = Object.assign(modalWrap, { id: mdl, className });
			document.body.append(modal);
			createRoot(modal).render(<Modal />);
		});
	},
});
