<?php

/**
 * The template for displaying product content within loops
 *
 * This template can be overridden by copying it to yourtheme/woocommerce/content-product.php.
 *
 * HOWEVER, on occasion WooCommerce will need to update template files and you
 * (the theme developer) will need to copy the new files to your theme to
 * maintain compatibility. We try to do this as little as possible, but it does
 * happen. When this occurs the version of the template file will be bumped and
 * the readme will list any important changes.
 *
 * @see     https://woocommerce.com/document/template-structure/
 * @package WooCommerce\Templates
 * @version 3.6.0
 */

defined('ABSPATH') || exit;

global $product;

// Ensure visibility.
if (empty($product) || !$product->is_visible()) {
	return;
}
if (!empty($_GET['super']) || 1 == 2) {
?>
	<li <?php wc_product_class('', $product); ?>>
		<?php
		/**
		 * Hook: woocommerce_before_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_open - 10
		 */
		do_action('woocommerce_before_shop_loop_item');

		/**
		 * Hook: woocommerce_before_shop_loop_item_title.
		 *
		 * @hooked woocommerce_show_product_loop_sale_flash - 10
		 * @hooked woocommerce_template_loop_product_thumbnail - 10
		 */
		do_action('woocommerce_before_shop_loop_item_title');

		/**
		 * Hook: woocommerce_shop_loop_item_title.
		 *
		 * @hooked woocommerce_template_loop_product_title - 10
		 */
		do_action('woocommerce_shop_loop_item_title');

		/**
		 * Hook: woocommerce_after_shop_loop_item_title.
		 *
		 * @hooked woocommerce_template_loop_rating - 5
		 * @hooked woocommerce_template_loop_price - 10
		 */
		do_action('woocommerce_after_shop_loop_item_title');

		/**
		 * Hook: woocommerce_after_shop_loop_item.
		 *
		 * @hooked woocommerce_template_loop_product_link_close - 5
		 * @hooked woocommerce_template_loop_add_to_cart - 10
		 */
		do_action('woocommerce_after_shop_loop_item');
		?>
	</li>

<?php } else {

	$imgg = get_template_directory_uri() . "/images/no_image.png";
	$imgg2 = get_template_directory_uri() . "/images/no_image.png";
	if (has_post_thumbnail()) :

		$imgg = get_the_post_thumbnail_url(get_the_ID(), 'medium');

	endif;
	$gal_images = $product->get_gallery_image_ids();
	if (count($gal_images) > 0):
		$imgg2 = wp_get_attachment_image_src($gal_images[0], 'medium')[0];
	endif;
?>

	<!-- Proddddddd -->
	<li <?php wc_product_class('item', $product); ?>>

		<img class="blocks_only_back" src="<?php e_url('/') ?>images/loop_item_1.png" alt="">
		<div class="product-wrapper blocks_only_font">

			<div class="thumbnail-wrapper">
				<a href="<?php the_permalink(); ?>">
					<figure class="has-back-image aspect-ratioo">
						<img loading="lazy" decoding="async" src="<?php e_url('/') ?>images/prod_loading.gif" data-src="<?= $imgg ?>" class="attachment-shop_catalog wp-post-image ts-lazy-load" />
						<img loading="lazy" decoding="async" src="<?php e_url('/') ?>images/prod_loading.gif" data-src="<?= $imgg2 ?>" class="product-image-back ts-lazy-load" />
					</figure>
				</a>
				<div class="product-label on-thumbnail">
					<?php if ($product->is_featured()) { ?>
						<span class="featured"><span>Hot</span></span>
					<?php }; ?>
					<?php if ($product->is_on_sale()) { ?>
						<span class="onsaleX"><span>Sale</span></span>
					<?php }; ?>
				</div>
				<div class="product-group-button">
					
					<?php //do_action( 'woocommerce_after_shop_loop_item' ); 	?>
					<div class="loop-add-to-cart">
						<!-- 	<a href="#shop/wood-outdoor-adirondack-chair/" data-quantity="1" class="button product_type_variable add_to_cart_button" data-product_id="3578" data-product_sku="0093" aria-label="Select options for &ldquo;Wood Outdoor Adirondack Chair&rdquo;" rel="nofollow"><span class="ts-tooltip button-tooltip">Select options</span></a> -->
						<?php
						if ($product->is_type('variable')) {
							echo apply_filters(
								'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
								sprintf(
									'<a href="%s" aria-describedby="woocommerce_loop_add_to_cart_link_describedby_%s" data-quantity="%s" class="button add_to_cart_button" data-product_id="%s" %s><span class="ts-tooltip button-tooltip">%s</span></a>',
									esc_url(get_the_permalink()),
									esc_attr($product->get_id()),
									esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
									esc_attr($product->get_id()),
									isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
									esc_html($product->add_to_cart_text())
								),
								$product,
								$args
							);
						} else {
							echo apply_filters(
								'woocommerce_loop_add_to_cart_link', // WPCS: XSS ok.
								sprintf(
									'<a href="%s" aria-describedby="woocommerce_loop_add_to_cart_link_describedby_%s" data-quantity="%s" class="button add_to_cart_button ajax_add_to_cart" data-product_id="%s" %s><span class="ts-tooltip button-tooltip">%s</span></a>',
									esc_url($product->add_to_cart_url()),
									esc_attr($product->get_id()),
									esc_attr(isset($args['quantity']) ? $args['quantity'] : 1),
									esc_attr($product->get_id()),
									isset($args['attributes']) ? wc_implode_html_attributes($args['attributes']) : '',
									esc_html($product->add_to_cart_text())
								),
								$product,
								$args
							);
						}
						?>
						<span id="woocommerce_loop_add_to_cart_link_describedby_<?php echo esc_attr($product->get_id()); ?>" class="screen-reader-text">
							<?php echo esc_html($args['aria-describedby_text']); ?>
						</span>

					</div>
					<div class="button-in wishlist">
						<?php echo do_shortcode('[yith_wcwl_add_to_wishlist]'); ?>


						<!-- <div class="yith-wcwl-add-to-wishlist add-to-wishlist-3578  wishlist-fragment on-first-load" data-fragment-ref="3578" data-fragment-options="{&quot;base_url&quot;:&quot;&quot;,&quot;in_default_wishlist&quot;:false,&quot;is_single&quot;:false,&quot;show_exists&quot;:false,&quot;product_id&quot;:3578,&quot;parent_product_id&quot;:3578,&quot;product_type&quot;:&quot;variable&quot;,&quot;show_view&quot;:false,&quot;browse_wishlist_text&quot;:&quot;Browse wishlist&quot;,&quot;already_in_wishslist_text&quot;:&quot;The product is already in your wishlist!&quot;,&quot;product_added_text&quot;:&quot;Product added!&quot;,&quot;heading_icon&quot;:&quot;fa-heart-o&quot;,&quot;available_multi_wishlist&quot;:false,&quot;disable_wishlist&quot;:false,&quot;show_count&quot;:false,&quot;ajax_loading&quot;:false,&quot;loop_position&quot;:&quot;after_add_to_cart&quot;,&quot;item&quot;:&quot;add_to_wishlist&quot;}">

						

						<div class="yith-wcwl-add-button">
							<a href="?add_to_wishlist=3578&#038;_wpnonce=4afc13a277" class="add_to_wishlist single_add_to_wishlist" data-product-id="3578" data-product-type="variable" data-original-product-id="3578" data-title="&lt;span class=&quot;ts-tooltip button-tooltip&quot; data-title=&quot;Add to wishlist&quot;&gt;Wishlist&lt;/span&gt;" rel="nofollow">
								<i class="yith-wcwl-icon fa fa-heart-o"></i> <span><span class="ts-tooltip button-tooltip" data-title="Add to wishlist">Wishlist</span></span>
							</a>
						</div>

						

					</div> -->
					</div>
					<div class="button-in compare">
						<a class="compare" href="<?= home_url() ?>?action=yith-woocompare-add-product&id=<?php echo $product->id; ?>" data-product_id="<?php echo $product->id; ?>"><span class="ts-tooltip button-tooltip" data-title="Add to compare">Compare</span></a>
					</div>
					<div class="button-in quickshop"><a class="yith-wcqv-button" href="#" data-product_id="<?php echo $product->id; ?>"><span class="ts-tooltip button-tooltip">Quick view</span></a></div>
				</div>
			</div>
			<div class="meta-wrapper">
				<h3 class="heading-title product-name"><a href="<?php the_permalink(); ?>"><?php the_title(); ?></a></h3>
				<div>
					<?php if ($price_html = $product->get_price_html()) : ?>
						<?php echo $price_html; ?>
					<?php endif; ?>
				</div>

				<div class="product-group-button-meta"></div>
			</div>
		</div>
		<div class="blocks_only_font">
			<?php //do_action('woocommerce_after_shop_loop_item');; 
			?>
		</div>
	</li>
	<!-- Proddddddd -->
<?php }; ?>