<?php

namespace App\Http\Controllers;

use App\Models\Page;
use Illuminate\Http\Request;
use Inertia\Inertia;
use App\Models\Session;
use App\Models\App;
use Auth;

class DashboardController extends Controller
{
    public function Index(Request $request)
    {
        $onlineThreshold = now()->subMinutes(60)->timestamp;

        $online_users = Session::whereNotNull('user_id')
            ->where('last_activity', '>=', $onlineThreshold)
            ->distinct('user_id')
            ->count('user_id');

        $recent_contacts = App::where("status",true)->orderBy('created_at', 'desc')->take(10)->get();

        $number_of_contacts = App::where("status",true)->count();

        $number_of_published_contacts = App::where("status",true)->where('published', true)->count();




        #dd($request->session()->get('message'));
        $messages = [
            'errors' => $request->session()->get('errors'),
            'message' => $request->session()->get('message'),
            'success' => $request->session()->get('success'),
        ];

        return Inertia::render('Dashboard/Index')->with(['messages' => $messages, 'number_of_contacts' => $number_of_contacts, 'number_of_published_contacts' => $number_of_published_contacts, 'online_users' => $online_users, 'recent_contacts' => $recent_contacts]);
    }

   
}
