<?php

namespace App\Http\Controllers;

use App\Models\Footer;
use App\Models\Language;
use Exception;
use Illuminate\Http\Request;
use Inertia\Inertia;

class FooterController extends Controller
{
    public function Index(Request $request)
    {
        $lang_id = $request->query('lang_id');

        if($lang_id){
            $footer = Footer::where('lang_id', $lang_id)->firstOrCreate(['lang_id' => $lang_id]);
            $languages = null;
        }else{
            $footer = null;
            $languages = Language::where('status', 1)->get();
        }

        

        $messages = [
            'errors' => session('errors'),
            'message' => session('message'),
            'success' => session('success'),
        ];

        return Inertia::render('Footer/Index')->with([
            'footer'=>$footer,
            'languages' => $languages,
            'messages' => $messages,
        ]);
    }

    public function Store(Request $request) {
        try{
            $validated = $request->validate([
                'component' => 'nullable|string',
                'styles' => 'nullable|string',
                'status' => 'nullable|boolean',
                'lang_id' => 'nullable|exists:languages,id',
            ]);

            $footer = Footer::where('lang_id', $validated['lang_id'] ?? null)->first();

            if (!$footer) {
                $footer = new Footer();
            }

            $footer->component = $validated['component'] ?? '';
            $footer->styles = $validated['styles'] ?? '';
            $footer->status = $validated['status'] ?? ($footer->status ?? true);
            $footer->lang_id = $validated['lang_id'] ?? null;

            $footer->save();

            session()->flash('success', 'Footer updated successfully!');
            return Inertia::location('/admin/dashboard');


        }catch(Exception $e){
            return response()->json([
                'message' => 'An error occurred while saving the footer.',
                'error' => $e->getMessage(),
            ], 500);
        }
    }
}
