<?php

namespace App\Http\Controllers;

use App\Models\Language;
use Illuminate\Http\Request;
use Inertia\Inertia;

use App\Models\Setting;

class SettingsController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index()
    {
        $Settings = Setting::first();
        $languages = Language::where('status', 1)->get();
        $app_name = $Settings?->app_name ?? config('app.name');

        $references = [
            'reference1' => $Settings?->reference1,
            'reference2' => $Settings?->reference2,
        ];

        $settings = [
            'app_name' => $app_name,
            'favicon' => $Settings?->favicon_url ?? '/public/favicon.png',
            'google_tag_id' => $Settings?->google_tag_id ?? '',
            'facebook_pixel_id' => $Settings?->facebook_pixel_id ?? '',
        ];

        return Inertia::render('Settings/Index',['settings' => $settings, 'references' => $references,
            'languages' => $languages,]);

    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        //
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            
            $validated = $request->validate([
                'app_name' => 'nullable|string|max:255',
                'reference1' => 'nullable|string|max:255',
                'reference2' => 'nullable|string|max:255',
                'google_tag_id' => 'nullable|string|max:255',
                'facebook_pixel_id' => 'nullable|string|max:255',
                'lang_id' => 'nullable|exists:languages,id',
            ]);


            $Settings = Setting::firstOrNew([]);

            $Settings->app_name = $validated['app_name'] ?? $Settings->app_name;
            $Settings->reference1 = $validated['reference1'] ?? $Settings->reference1;
            $Settings->reference2 = $validated['reference2'] ?? $Settings->reference2;
            $Settings->google_tag_id = $validated['google_tag_id'] ?? $Settings->google_tag_id;
            $Settings->facebook_pixel_id = $validated['facebook_pixel_id'] ?? $Settings->facebook_pixel_id;
            $Settings->lang_id = $validated['lang_id'] ?? $Settings->lang_id;
            

            //update the favicon
            if ($request->file('favicon')) {
                // Get file extension
                $extension = $request->file('favicon')->getClientOriginalExtension();

                // Rename to favicon.ext
                $fileName = 'favicon.' . $extension;

                $filePath = $request->file('favicon')->storeAs('assets', $fileName, 'public'); // Store the file in the 'public/assets' directory

                if (env('APP_ENV') == 'local') {
                    $Settings->favicon_url = asset("storage/assets/$fileName");
                } else {
                    $Settings->favicon_url = "/storage/app/public/assets/$fileName";
                }
            }else{
                $Settings->favicon_url = $request->get('favicon') ?? '';
            }

            
            $Settings->save();

            session()->flash('success', 'Settings updated successfully!');
            return Inertia::location('/admin/settings');
        } catch (\Exception $e) {
            session()->flash('errors', 'An error occurred while updating settings: ' . $e->getMessage());
            return back()->withInput();
        }
    }

    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id)
    {
        //
    }

    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        //
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        //
    }
}
