<?php

namespace App\Http\Controllers;

use Illuminate\Http\Request;
use App\Models\SocialType;
use Inertia\Inertia;

class SocialTypeController extends Controller
{
    /**
     * Display a listing of the resource.
     */
    public function index(Request $request)
    {
        $social_types = SocialType::where('status', true)->get();

        $messages = [
            'errors' => $request->session()->get('errors'),
            'message' => $request->session()->get('message'),
            'success' => $request->session()->get('success'),
        ];

        return Inertia::render('SocialTypes/Index', ['social_types' => $social_types,"messages" => $messages]);
    }

    /**
     * Show the form for creating a new resource.
     */
    public function create()
    {
        $social_types = SocialType::where('status', true)->get();

        return Inertia::render('SocialTypes/Index', ['social_types' => $social_types]);
    }

    /**
     * Store a newly created resource in storage.
     */
    public function store(Request $request)
    {
        try {
            $validated = $request->validate([
                'icon' => 'string|nullable',
                'color' => 'string|max:10|nullable',
                'base_url' => 'string|nullable',
                'end_url' => 'string|nullable',
                'type' => 'string|max:50|required',
            ]);

            $socialType = new SocialType();

            $socialType->type = $validated['type'] ?? '';
            $socialType->color = $validated['color'] ?? '';
            $socialType->base_url = $validated['base_url'] ?? '';
            $socialType->end_url = $validated['end_url'] ?? '';
            $socialType->icon = $validated['icon'] ?? '';

            if ($socialType->save()) {
                return redirect()->route('social-links.index')->with('success', 'Social Link created successfully!');
            }

            return response()->json(['message' => 'Failed to create social type', 'status' => 400], 400);
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage(), 'status' => 500], 500);
        }
    }


    /**
     * Display the specified resource.
     */
    public function show(string $id)
    {
        //
    }

    /**
     * Show the form for editing the specified resource.
     */
    public function edit(string $id,Request $request)
    {
        $selected_type = SocialType::find($id);
        $social_types = SocialType::where('status', true)->get();

        $messages = [
            'errors' => $request->session()->get('errors'),
            'message' => $request->session()->get('message'),
            'success' => $request->session()->get('success'),
        ];

        return Inertia::render('SocialTypes/Update', ['social_types' => $social_types, 'selected_type' => $selected_type, 'messages' => $messages]);

    }



    /**
     * Update the specified resource in storage.
     */
    public function update(Request $request, string $id)
    {
        try {
            $validated = $request->validate([
                'icon' => 'string|nullable',
                'color' => 'string|max:10|nullable',
                'base_url' => 'string|nullable',
                'end_url' => 'string|nullable',
                'type' => 'string|max:50|nullable',
            ]);

            $socialType = SocialType::findorfail($id);

            $socialType->type = $validated['type'] ?? $socialType->type;
            $socialType->color = $validated['color'] ?? $socialType->color;
            $socialType->base_url = $validated['base_url'] ?? $socialType->base_url;
            $socialType->end_url = $validated['end_url'] ?? $socialType->end_url;
            $socialType->icon = $validated['icon'] ?? $socialType->icon;

            if ($socialType->save()) {
                session()->flash('success', 'Social link updated successfully!');
                return Inertia::location('/admin/social-links');
            }

            session()->flash('errors', 'Failed to update social type!');
            return redirect()->back();
        } catch (\Exception $e) {
            return response()->json(['message' => $e->getMessage(), 'status' => 500], 500);
        }
    }

    /**
     * Remove the specified resource from storage.
     */
    public function destroy(string $id)
    {
        try {
            $Social_type = SocialType::find($id);
            $Social_type->status = false;
            if ($Social_type->save()) {
                session()->flash('success', 'Social link deleted successfully!');
                return Inertia::location('/admin/social-links');
            }

            session()->flash('errors', 'Could not delete social link!');

            return redirect()->back();
        } catch (Exception $e) {

        }
    }
}
