<?php

namespace App\Http\Middleware;

use Closure;
use Illuminate\Http\Request;
use Symfony\Component\HttpFoundation\Response;
use Auth;


class CheckPermission
{
    /**
     * Handle an incoming request.
     *
     * @param  \Closure(\Illuminate\Http\Request): (\Symfony\Component\HttpFoundation\Response)  $next
     */
    public function handle(Request $request, Closure $next, $attribute)
    {
        // Retrieve the authenticated user
        $user = Auth::user();

        // Check if the user is authenticated
        if ($user) {
            // Retrieve user settings
            $settings = $user->roles;

            // Check if the attribute exists and is true
            if ($settings && $settings->$attribute) {
                // Permission granted, proceed to the next middleware
                return $next($request);
            }
        }

        // Permission denied, return an error response
        return redirect()->route('dashboard')->withErrors(['Permission' => 'you can not access this page']);
    }
}
