<?php

namespace App\Jobs;

use Illuminate\Contracts\Queue\ShouldQueue;
use Illuminate\Foundation\Queue\Queueable;

use Illuminate\Support\Facades\Mail;
use App\Mail\DailyActivationMail;
use App\Models\App;
use Illuminate\Support\Facades\Log;
class DailyActivation implements ShouldQueue
{
    use Queueable;

    /**
     * Create a new job instance.
     */
    public function __construct()
    {
        //
    }

    /**
     * Execute the job.
     */
    public function handle(): void
    {
        //get Apps where activation_date is due 30days from now
        $expiry_contacts = App::whereDate('subscription_end_date', '<=', now()->addDays(30))->whereDate('subscription_end_date', '>', now())->where('status', 1)->where('published', 1)->orderBy("subscription_end_date")->get();

        Log::info('DailyActivation job fetched contacts:', [
            'count' => $expiry_contacts->count(),
            'contacts' => $expiry_contacts->toArray(),
        ]);
        //send email to admin
        Mail::to(env('MAIL_TO_ADDRESS'))->send(new DailyActivationMail($expiry_contacts));

    }
}
