<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('app_socials', function (Blueprint $table) {
            $table->id();
            $table->foreignId('app_id')
                  ->constrained('apps');
            $table->foreignId('social_type_id')
                  ->nullable()
                  ->constrained('social_types')
                  ->onDelete('set null');
            $table->string('link')->default('');
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
         Schema::table('app_socials', function (Blueprint $table) {
            $table->dropForeign(['app_id']);
            $table->dropForeign(['social_type_id']);
        });

        Schema::dropIfExists('app_socials');
    }
};
