<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('user_roles', function (Blueprint $table) {
            $table->id();
            $table->foreignId('user_id')
                ->constrained('users');
            $table->boolean('contactsF')->default(false);
            $table->boolean('contactsA')->default(false);
            $table->boolean('contactsE')->default(false);
            $table->boolean('contactsD')->default(false);
            $table->boolean('socialF')->default(false);
            $table->boolean('socialA')->default(false);
            $table->boolean('socialE')->default(false);
            $table->boolean('socialD')->default(false);
            $table->boolean('settingsF')->default(false);
            $table->boolean('settingsE')->default(false);
            $table->boolean('usersF')->default(false);
            $table->boolean('usersA')->default(false);
            $table->boolean('usersE')->default(false);
            $table->boolean('usersD')->default(false);
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('user_roles');
    }
};
