<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('menu_items', function (Blueprint $table) {
            $table->string('id')->primary(); // Allows manual assignment of 'id'
            $table->string('parent_id')->nullable(); // Allows manual assignment of 'parent_id'
            $table->foreignId('menu_id')
            ->nullable()
            ->constrained('menus')
            ->onDelete('cascade');
            $table->string('title')->default('');
            $table->string(column: 'link')->default('');
            $table->string(column: 'type')->default('link');
            $table->integer('order')->default(0); 
            $table->timestamps();
        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('menu_items');
    }
};
