<?php

namespace Database\Seeders;

use DB;
use Illuminate\Database\Console\Seeds\WithoutModelEvents;
use Illuminate\Database\Seeder;

class PagesSeeder extends Seeder
{
    /**
     * Run the database seeds.
     */
    public function run(): void
    {
        DB::table('pages')->insert([
            [
                'title' => 'Home',
                'slug' => '',
                'component' => '<!DOCTYPE html> <html lang="en" class="no-js"> <head> <meta charset="utf-8"> <meta http-equiv="X-UA-Compatible" content="IE=edge"> <meta name="viewport" content="width=device-width, initial-scale=1"> <title>Laurel Template</title> <link href="https://fonts.googleapis.com/css?family=Heebo:400,500,700|Playfair+Display:700" rel="stylesheet"> <style> html{line-height:1.15;-ms-text-size-adjust:100%;-webkit-text-size-adjust:100%}body{margin:0}article,aside,footer,header,nav,section{display:block}h1{font-size:2em;margin:0.67em 0}figcaption,figure,main{display:block}figure{margin:1em 40px}hr{box-sizing:content-box;height:0;overflow:visible}pre{font-family:monospace, monospace;font-size:1em}a{background-color:transparent;-webkit-text-decoration-skip:objects}abbr[title]{border-bottom:none;text-decoration:underline;-webkit-text-decoration:underline dotted;text-decoration:underline dotted}b,strong{font-weight:inherit}b,strong{font-weight:bolder}code,kbd,samp{font-family:monospace, monospace;font-size:1em}dfn{font-style:italic}mark{background-color:#ff0;color:#000}small{font-size:80%}sub,sup{font-size:75%;line-height:0;position:relative;vertical-align:baseline}sub{bottom:-0.25em}sup{top:-0.5em}audio,video{display:inline-block}audio:not([controls]){display:none;height:0}img{border-style:none}svg:not(:root){overflow:hidden}button,input,optgroup,select,textarea{font-family:sans-serif;font-size:100%;line-height:1.15;margin:0}button,input{overflow:visible}button,select{text-transform:none}button,html [type="button"],[type="reset"],[type="submit"]{-webkit-appearance:button}button::-moz-focus-inner,[type="button"]::-moz-focus-inner,[type="reset"]::-moz-focus-inner,[type="submit"]::-moz-focus-inner{border-style:none;padding:0}button:-moz-focusring,[type="button"]:-moz-focusring,[type="reset"]:-moz-focusring,[type="submit"]:-moz-focusring{outline:1px dotted ButtonText}fieldset{padding:0.35em 0.75em 0.625em}legend{box-sizing:border-box;color:inherit;display:table;max-width:100%;padding:0;white-space:normal}progress{display:inline-block;vertical-align:baseline}textarea{overflow:auto}[type="checkbox"],[type="radio"]{box-sizing:border-box;padding:0}[type="number"]::-webkit-inner-spin-button,[type="number"]::-webkit-outer-spin-button{height:auto}[type="search"]{-webkit-appearance:textfield;outline-offset:-2px}[type="search"]::-webkit-search-cancel-button,[type="search"]::-webkit-search-decoration{-webkit-appearance:none}::-webkit-file-upload-button{-webkit-appearance:button;font:inherit}details,menu{display:block}summary{display:list-item}canvas{display:inline-block}template{display:none}[hidden]{display:none}html{box-sizing:border-box}*,*:before,*:after{box-sizing:inherit}body{background:#06101F;-moz-osx-font-smoothing:grayscale;-webkit-font-smoothing:antialiased}hr{border:0;display:block;height:1px;background:#273C5A;background:linear-gradient(to right, rgba(39,60,90,0.1) 0, rgba(39,60,90,0.6) 50%, rgba(39,60,90,0.1) 100%);margin-top:24px;margin-bottom:24px}ul,ol{margin-top:0;margin-bottom:24px;padding-left:24px}ul{list-style:disc}ol{list-style:decimal}li>ul,li>ol{margin-bottom:0}dl{margin-top:0;margin-bottom:24px}dt{font-weight:700}dd{margin-left:24px;margin-bottom:24px}img{height:auto;max-width:100%;vertical-align:middle}figure{margin:24px 0}figcaption{font-size:16px;line-height:24px;padding:8px 0}img,svg{display:block}table{border-collapse:collapse;margin-bottom:24px;width:100%}tr{border-bottom:1px solid #273C5A}th{text-align:left}th,td{padding:10px 16px}th:first-child,td:first-child{padding-left:0}th:last-child,td:last-child{padding-right:0}html{font-size:20px;line-height:30px}body{color:#7487A3;font-size:1rem}body,button,input,select,textarea{font-family:"Heebo", sans-serif}a{color:#F9425F;text-decoration:none}a:hover,a:active{outline:0;text-decoration:underline}h1,h2,h3,h4,h5,h6,.h1,.h2,.h3,.h4,.h5,.h6{clear:both;color:#fff;font-family:"Playfair Display", serif;font-weight:700}h1,.h1{font-size:44px;line-height:56px;letter-spacing:0px}@media (min-width: 641px){h1,.h1{font-size:48px;line-height:62px;letter-spacing:0px}}h2,.h2{font-size:40px;line-height:52px;letter-spacing:0px}@media (min-width: 641px){h2,.h2{font-size:44px;line-height:56px;letter-spacing:0px}}h3,.h3,blockquote{font-size:24px;line-height:34px;letter-spacing:-0.1px}h4,h5,h6,.h4,.h5,.h6{font-size:20px;line-height:30px;letter-spacing:-0.1px}@media (max-width: 640px){.h1-mobile{font-size:44px;line-height:56px;letter-spacing:0px}.h2-mobile{font-size:40px;line-height:52px;letter-spacing:0px}.h3-mobile{font-size:24px;line-height:34px;letter-spacing:-0.1px}.h4-mobile,.h5-mobile,.h6-mobile{font-size:20px;line-height:30px;letter-spacing:-0.1px}}.text-light h1,.text-light h2,.text-light h3,.text-light h4,.text-light h5,.text-light h6,.text-light .h1,.text-light .h2,.text-light .h3,.text-light .h4,.text-light .h5,.text-light .h6{color:!important}.text-sm{font-size:18px;line-height:27px;letter-spacing:-0.1px}.text-xs{font-size:16px;line-height:24px;letter-spacing:-0.1px}h1,h2,.h1,.h2{margin-top:48px;margin-bottom:16px}h3,.h3{margin-top:36px;margin-bottom:12px}h4,h5,h6,.h4,.h5,.h6{margin-top:24px;margin-bottom:4px}p{margin-top:0;margin-bottom:24px}dfn,cite,em,i{font-style:italic}blockquote{color:#556B8B;font-style:italic;margin-top:24px;margin-bottom:24px;margin-left:24px}blockquote::before{content:"\201C"}blockquote::after{content:"\201D"}blockquote p{display:inline}address{color:#7487A3;border-width:1px 0;border-style:solid;border-color:#273C5A;padding:24px 0;margin:0 0 24px}pre,pre h1,pre h2,pre h3,pre h4,pre h5,pre h6,pre .h1,pre .h2,pre .h3,pre .h4,pre .h5,pre .h6{font-family:"Courier 10 Pitch", Courier, monospace}pre,code,kbd,tt,var{background:#1D304B}pre{font-size:16px;line-height:24px;margin-bottom:1.6em;max-width:100%;overflow:auto;padding:24px;margin-top:24px;margin-bottom:24px}code,kbd,tt,var{font-family:Monaco, Consolas, "Andale Mono", "DejaVu Sans Mono", monospace;font-size:16px;padding:2px 4px}abbr,acronym{cursor:help}mark,ins{text-decoration:none}small{font-size:18px;line-height:27px;letter-spacing:-0.1px}b,strong{font-weight:700}button,input,select,textarea,label{font-size:20px;line-height:30px}.container,.container-sm{width:100%;margin:0 auto;padding-left:16px;padding-right:16px}@media (min-width: 481px){.container,.container-sm{padding-left:24px;padding-right:24px}}.container{max-width:1128px}.container-sm{max-width:848px}.container .container-sm{max-width:800px;padding-left:0;padding-right:0}.screen-reader-text{clip:rect(1px, 1px, 1px, 1px);position:absolute !important;height:1px;width:1px;overflow:hidden;word-wrap:normal !important}.screen-reader-text:focus{border-radius:2px;box-shadow:0 0 2px 2px rgba(0,0,0,0.6);clip:auto !important;display:block;font-size:14px;letter-spacing:0px;font-weight:700;line-height:16px;text-decoration:none;text-transform:uppercase;background-color:#06101F;color:#F9425F !important;border:none;height:auto;left:8px;padding:16px 32px;top:8px;width:auto;z-index:100000}.list-reset{list-style:none;padding:0}.text-left{text-align:left}.text-center{text-align:center}.text-right{text-align:right}.text-primary{color:#F9425F}.text-secondary{color:#47A1F9}.has-top-divider{position:relative}.has-top-divider::before{content:"";position:absolute;top:0;left:0;width:100%;display:block;height:1px;background:#273C5A;background:linear-gradient(to right, rgba(39,60,90,0.1) 0, rgba(39,60,90,0.6) 50%, rgba(39,60,90,0.1) 100%)}.has-bottom-divider{position:relative}.has-bottom-divider::after{content:"";position:absolute;bottom:0;left:0;width:100%;display:block;height:1px;background:#273C5A;background:linear-gradient(to right, rgba(39,60,90,0.1) 0, rgba(39,60,90,0.6) 50%, rgba(39,60,90,0.1) 100%)}.m-0{margin:0}.mt-0{margin-top:0}.mr-0{margin-right:0}.mb-0{margin-bottom:0}.ml-0{margin-left:0}.m-8{margin:8px}.mt-8{margin-top:8px}.mr-8{margin-right:8px}.mb-8{margin-bottom:8px}.ml-8{margin-left:8px}.m-16{margin:16px}.mt-16{margin-top:16px}.mr-16{margin-right:16px}.mb-16{margin-bottom:16px}.ml-16{margin-left:16px}.m-24{margin:24px}.mt-24{margin-top:24px}.mr-24{margin-right:24px}.mb-24{margin-bottom:24px}.ml-24{margin-left:24px}.m-32{margin:32px}.mt-32{margin-top:32px}.mr-32{margin-right:32px}.mb-32{margin-bottom:32px}.ml-32{margin-left:32px}.m-40{margin:40px}.mt-40{margin-top:40px}.mr-40{margin-right:40px}.mb-40{margin-bottom:40px}.ml-40{margin-left:40px}.m-48{margin:48px}.mt-48{margin-top:48px}.mr-48{margin-right:48px}.mb-48{margin-bottom:48px}.ml-48{margin-left:48px}.m-56{margin:56px}.mt-56{margin-top:56px}.mr-56{margin-right:56px}.mb-56{margin-bottom:56px}.ml-56{margin-left:56px}.m-64{margin:64px}.mt-64{margin-top:64px}.mr-64{margin-right:64px}.mb-64{margin-bottom:64px}.ml-64{margin-left:64px}.p-0{padding:0}.pt-0{padding-top:0}.pr-0{padding-right:0}.pb-0{padding-bottom:0}.pl-0{padding-left:0}.p-8{padding:8px}.pt-8{padding-top:8px}.pr-8{padding-right:8px}.pb-8{padding-bottom:8px}.pl-8{padding-left:8px}.p-16{padding:16px}.pt-16{padding-top:16px}.pr-16{padding-right:16px}.pb-16{padding-bottom:16px}.pl-16{padding-left:16px}.p-24{padding:24px}.pt-24{padding-top:24px}.pr-24{padding-right:24px}.pb-24{padding-bottom:24px}.pl-24{padding-left:24px}.p-32{padding:32px}.pt-32{padding-top:32px}.pr-32{padding-right:32px}.pb-32{padding-bottom:32px}.pl-32{padding-left:32px}.p-40{padding:40px}.pt-40{padding-top:40px}.pr-40{padding-right:40px}.pb-40{padding-bottom:40px}.pl-40{padding-left:40px}.p-48{padding:48px}.pt-48{padding-top:48px}.pr-48{padding-right:48px}.pb-48{padding-bottom:48px}.pl-48{padding-left:48px}.p-56{padding:56px}.pt-56{padding-top:56px}.pr-56{padding-right:56px}.pb-56{padding-bottom:56px}.pl-56{padding-left:56px}.p-64{padding:64px}.pt-64{padding-top:64px}.pr-64{padding-right:64px}.pb-64{padding-bottom:64px}.pl-64{padding-left:64px}.sr .has-animations .is-revealing{visibility:hidden}.input,.textarea{background-color:#fff;border-width:1px;border-style:solid;border-color:#273C5A;border-radius:2px;color:#7487A3;max-width:100%;width:100%}.input::-moz-placeholder, .textarea::-moz-placeholder{color:#556B8B}.input::placeholder,.textarea::placeholder{color:#556B8B}.input::-ms-input-placeholder,.textarea::-ms-input-placeholder{color:#556B8B}.input:-ms-input-placeholder,.textarea:-ms-input-placeholder{color:#556B8B}.input:hover,.textarea:hover{border-color:#1f3048}.input:active,.input:focus,.textarea:active,.textarea:focus{outline:none;border-color:#273C5A}.input[disabled],.textarea[disabled]{cursor:not-allowed;background-color:#1D304B;border-color:#1D304B}.input{-moz-appearance:none;-webkit-appearance:none;font-size:16px;letter-spacing:-0.1px;line-height:20px;padding:13px 16px;height:48px;box-shadow:none}.input .inline-input{display:inline;width:auto}.textarea{display:block;min-width:100%;resize:vertical}.textarea .inline-textarea{display:inline;width:auto}.field-grouped>.control:not(:last-child){margin-bottom:8px}@media (min-width: 641px){.field-grouped{display:flex}.field-grouped>.control{flex-shrink:0}.field-grouped>.control.control-expanded{flex-grow:1;flex-shrink:1}.field-grouped>.control:not(:last-child){margin-bottom:0;margin-right:8px}}.button{display:inline-flex;font-size:14px;letter-spacing:0px;font-weight:700;line-height:16px;text-decoration:none !important;text-transform:uppercase;background-color:#273C5A;color:#fff !important;border:none;border-radius:2px;cursor:pointer;justify-content:center;padding:16px 32px;height:48px;text-align:center;white-space:nowrap}.button:hover{background:#293e5e}.button:active{outline:0}.button::before{border-radius:2px}.button-shadow{position:relative}.button-shadow::before{content:"";position:absolute;top:0;right:0;bottom:0;left:0;box-shadow:0 8px 24px rgba(6,16,31,0.25);mix-blend-mode:multiply;transition:box-shadow .15s ease}.button-shadow:hover::before{box-shadow:0 8px 24px rgba(6,16,31,0.35)}.button-sm{padding:8px 24px;height:32px}.button-sm.button-shadow::before{box-shadow:0 4px 16px rgba(6,16,31,0.25)}.button-sm.button-shadow:hover::before{box-shadow:0 4px 16px rgba(6,16,31,0.35)}.button-primary{background-color:#F9425F}.button-primary:hover{background:#f94763}.button-primary.button-shadow::before{box-shadow:0 8px 16px rgba(249,66,95,0.25);mix-blend-mode:normal}.button-primary.button-shadow:hover::before{box-shadow:0 8px 16px rgba(249,66,95,0.35)}.button-primary .button-sm.button-shadow::before{box-shadow:0 4px 16px rgba(249,66,95,0.25)}.button-primary .button-sm.button-shadow:hover::before{box-shadow:0 4px 16px rgba(249,66,95,0.35)}.button-block{display:flex}.site-header{position:relative;padding:24px 0}.site-header::before{content:"";position:absolute;right:0;top:0;width:373px;height:509px;background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMzczIiBoZWlnaHQ9IjUwOSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4gIDxkZWZzPiAgICA8bGluZWFyR3JhZGllbnQgeDE9IjkyLjgyNyUiIHkxPSIwJSIgeDI9IjUzLjQyMiUiIHkyPSI4MC4wODclIiBpZD0iYSI+ICAgICAgPHN0b3Agc3RvcC1jb2xvcj0iI0Y5NDI1RiIgb2Zmc2V0PSIwJSIvPiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiNGOTdDNTgiIHN0b3Atb3BhY2l0eT0iMCIgb2Zmc2V0PSIxMDAlIi8+ICAgIDwvbGluZWFyR3JhZGllbnQ+ICAgIDxsaW5lYXJHcmFkaWVudCB4MT0iOTIuODI3JSIgeTE9IjAlIiB4Mj0iNTMuNDA2JSIgeTI9IjgwLjEyJSIgaWQ9ImIiPiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiM0N0ExRjkiIG9mZnNldD0iMCUiLz4gICAgICA8c3RvcCBzdG9wLWNvbG9yPSIjRjk0MjVGIiBzdG9wLW9wYWNpdHk9IjAiIG9mZnNldD0iODAuNTMyJSIvPiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiNGREZGREEiIHN0b3Atb3BhY2l0eT0iMCIgb2Zmc2V0PSIxMDAlIi8+ICAgIDwvbGluZWFyR3JhZGllbnQ+ICA8L2RlZnM+ICA8ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPiAgICA8cGF0aCBkPSJNNTY5LjY4IDBjLTE5LjU2NSA1OC42NS00OC45NzMgODIuNjA5LTg4LjIyNiA3MS44NzktNTguODgtMTYuMDk1LTE1OC45LTE4LjI2NS0yMTEuMzkyIDc2Ljg0NS01Mi40OTMgOTUuMTExLTEyMC42ODcgMTQxLjA0My0xODAuMjMzIDk5LjY0NUM1MC4xMyAyMjAuNzY5IDIwLjE4OCAyNDEuOTA0IDAgMzExLjc3TDI1Ni40MzkgNDc2YzE3My41MDYtMy41NjUgMjU2LjAwOS00My4zNzQgMjQ3LjUwNy0xMTkuNDI2LTguNTAyLTc2LjA1MiAyOC45MjMtMTM3LjQ0NSAxMTIuMjc1LTE4NC4xNzhMNjIwIDcxLjg4IDU2OS42OCAweiIgZmlsbD0idXJsKCNhKSIgdHJhbnNmb3JtPSJ0cmFuc2xhdGUoMSAtMjA5KSIvPiAgICA8cGF0aCBkPSJNNjg0Ljk2MSAxODYuNDYxYy0xOS42NTYgNTguNTI4LTQ5LjEzNSA4Mi40Ni04OC40MzggNzEuNzk3LTU4Ljk1NS0xNS45OTQtMTU5LjEyOS0xOC4wNTQtMjExLjgwNCA3Ni44ODEtNTIuNjc0IDk0LjkzNS0xMjEuMDIzIDE0MC44MjctMTgwLjYyIDk5LjU5Mi0zOS43My0yNy40OS02OS43NDItNi4zNzYtOTAuMDM1IDYzLjM0M2wyNTYuNjY4IDE2My41NmMxNzMuNzgyLTMuNzM5IDI1Ni40NTUtNDMuNTM3IDI0OC4wMi0xMTkuMzk2LTguNDM2LTc1Ljg1OCAyOS4xMTItMTM3LjE0MSAxMTIuNjQ0LTE4My44NDhsMy44OS0xMDAuMjc3LTUwLjMyNS03MS42NTJ6IiBmaWxsPSJ1cmwoI2IpIiB0cmFuc2Zvcm09InJvdGF0ZSgtNTMgMjE1LjU4IDMxOC41NDUpIi8+ICA8L2c+PC9zdmc+)}.site-header-inner{position:relative;display:flex;justify-content:space-between;align-items:center}.header-links{display:inline-flex}.header-links li{display:inline-flex}.header-links a:not(.button){font-size:16px;line-height:24px;letter-spacing:-0.1px;font-weight:700;text-transform:uppercase;text-decoration:none;line-height:16px;padding:8px 24px}@media (min-width: 641px){.site-header::before{display:none}}.hero{text-align:center;padding-top:48px;padding-bottom:24px}.hero-copy{position:relative}.hero-paragraph{margin-bottom:32px}.hero-app{position:relative}.hero-app-illustration{position:absolute;top:-358px;left:calc(50% - 436px);pointer-events:none}.hero-app-dots{display:none;position:absolute}.hero-app-dots-1{top:15px;left:-108px}.hero-app-dots-2{bottom:100px;left:320px}.device-mockup{position:relative;width:350px;height:auto;margin:0 auto;visibility:hidden;opacity:0;transform:translateY(40px);transition:opacity 0.6s cubic-bezier(0.5, -0.01, 0, 1.005),transform 0.6s cubic-bezier(0.5, -0.01, 0, 1.005)}.device-mockup.has-loaded{visibility:visible;opacity:1;transform:translateY(0)}.hero-cta{max-width:400px;margin-left:auto;margin-right:auto;margin-bottom:40px}@media (max-width: 639px){.hero-cta .button{display:flex}.hero-cta .button+.button{margin-top:16px}.hero-shape-top{display:none}}@media (min-width: 641px){.hero{position:relative;text-align:left;padding-top:56px;padding-bottom:12px}.hero::before{content:"";position:absolute;left:0;bottom:20px;width:415px;height:461px;background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDE1IiBoZWlnaHQ9IjQ2MSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4gIDxkZWZzPiAgICA8bGluZWFyR3JhZGllbnQgeDE9IjguNjg1JSIgeTE9IjIzLjczMyUiIHgyPSI5OS40MzUlIiB5Mj0iODUuMDc4JSIgaWQ9ImEiPiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiMxRDMwNEIiIG9mZnNldD0iMCUiLz4gICAgICA8c3RvcCBzdG9wLWNvbG9yPSIjMUQzMDRCIiBzdG9wLW9wYWNpdHk9IjAiIG9mZnNldD0iMTAwJSIvPiAgICA8L2xpbmVhckdyYWRpZW50PiAgPC9kZWZzPiAgPHBhdGggZD0iTTMxOC4xNzEgNjE2LjY0YzE2MC4wODYgMCA3MDIuNTI3LTIyOC4yNiAyODkuODYyLTI5MC00MTIuNjY2LTYxLjczOC0xMjkuNzc2LTI5MC0yODkuODYyLTI5MFMyOC4zMSAxNjYuNDc5IDI4LjMxIDMyNi42NGMwIDE2MC4xNjMgMTI5Ljc3NSAyOTAgMjg5Ljg2MSAyOTB6IiB0cmFuc2Zvcm09InJvdGF0ZSgtNiAtMTMyNy4wMyAzNTk0LjM4KSIgZmlsbD0idXJsKCNhKSIgZmlsbC1ydWxlPSJldmVub2RkIi8+PC9zdmc+)}.hero-inner{display:flex;justify-content:space-between}.hero-copy{padding-top:88px;padding-right:48px;min-width:448px;max-width:588px}.hero-title{margin-bottom:24px}.hero-paragraph{margin-bottom:40px}.hero-app-illustration{left:-257px}.hero-app-dots{display:block}.device-mockup{max-width:none}.hero-cta{margin:0}.hero-cta .button{min-width:170px}.hero-cta .button:first-child{margin-right:16px}}.features .section-title{margin-bottom:48px}.features-wrap{display:flex;flex-wrap:wrap;justify-content:space-evenly;margin-right:-30px;margin-left:-30px}.features-wrap:first-of-type{margin-top:-16px}.features-wrap:last-of-type{margin-bottom:-16px}.feature{padding:16px 30px;width:380px;max-width:380px;flex-grow:1}.feature-inner{height:100%}.feature-title{font-family:"Heebo", sans-serif;font-weight:500}@media (min-width: 641px){.features{position:relative}.features .section-inner{padding-bottom:100px}.features .section-title{position:relative;margin-bottom:80px}.features .section-title::before{content:"";position:absolute;left:-40px;top:-25px;width:49px;height:50px;background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iNDkiIGhlaWdodD0iNTAiIHhtbG5zPSJodHRwOi8vd3d3LnczLm9yZy8yMDAwL3N2ZyI+ICA8ZyBmaWxsPSJub25lIiBmaWxsLXJ1bGU9ImV2ZW5vZGQiPiAgICA8cGF0aCBmaWxsPSIjMjczQzVBIiBkPSJNMTQuMTM4IDlsLTcuOTczIDMuNjY3TDQgMjAuNDMybDIuNTQ3IDcuMzkzTDE0LjEzNyAzMWw3LjE0OC0zLjYwNUwyNiAyMC40MzJsLTMuNTYzLTguMDgzeiIvPiAgICA8cGF0aCBmaWxsPSIjNzQ4N0EzIiBkPSJNNDYuMzA0IDBsLTEuODEyLjgzM0w0NCAyLjU5OGwuNTc5IDEuNjhMNDYuMzA0IDVsMS42MjQtLjgyTDQ5IDIuNTk5IDQ4LjE5Ljc2MXpNMi4zMDQgNDVsLTEuODEyLjgzM0wwIDQ3LjU5OGwuNTc5IDEuNjhMMi4zMDQgNTBsMS42MjQtLjgyTDUgNDcuNTk5bC0uODEtMS44Mzd6Ii8+ICA8L2c+PC9zdmc+)}.features::before{content:"";position:absolute;right:0;top:60px;width:257px;height:279px;background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjU3IiBoZWlnaHQ9IjI3OSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4gIDxkZWZzPiAgICA8bGluZWFyR3JhZGllbnQgeDE9IjguNjg1JSIgeTE9IjIzLjczMyUiIHgyPSI5OS40MzUlIiB5Mj0iODUuMDc4JSIgaWQ9ImEiPiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiMxRDMwNEIiIG9mZnNldD0iMCUiLz4gICAgICA8c3RvcCBzdG9wLWNvbG9yPSIjMUQzMDRCIiBzdG9wLW9wYWNpdHk9IjAiIG9mZnNldD0iMTAwJSIvPiAgICA8L2xpbmVhckdyYWRpZW50PiAgPC9kZWZzPiAgPHBhdGggZD0iTTE4MzAuMTcxIDEwMTcuNjRjMTYwLjA4NiAwIDcwMi41MjctMjI4LjI2IDI4OS44NjItMjkwLTQxMi42NjYtNjEuNzM3LTEyOS43NzYtMjkwLTI4OS44NjItMjkwcy0yODkuODYxIDEyOS44MzgtMjg5Ljg2MSAyOTBjMCAxNjAuMTYzIDEyOS43NzUgMjkwIDI4OS44NjEgMjkweiIgdHJhbnNmb3JtPSJzY2FsZSgtMSAxKSByb3RhdGUoLTYgLTU4NTQuMTU0IDIyMTE0Ljg1NykiIGZpbGw9InVybCgjYSkiIGZpbGwtcnVsZT0iZXZlbm9kZCIvPjwvc3ZnPg==)}.features-wrap:first-of-type{margin-top:-32px}.features-wrap:last-of-type{margin-bottom:-32px}.feature{padding:32px 30px}}.media .section-inner{padding-bottom:104px}.media .section-paragraph{margin-bottom:48px}.media-canvas{position:relative}.media-canvas svg{position:relative;width:100%;height:auto}.media-canvas::before{content:"";position:absolute;width:320px;height:230px;bottom:-76px;left:calc(50% - 160px);background-image:url(data:image/svg+xml;base64,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);background-repeat:no-repeat;background-size:320px 230px}.media-control{position:absolute;top:calc(50% - 24px);left:calc(50% - 24px);cursor:pointer}.media-control svg{width:48px;height:48px;overflow:visible}@media (min-width: 641px){.media .section-inner{padding-bottom:144px}.media .section-paragraph{padding-left:72px;padding-right:72px;margin-bottom:80px}.media-canvas::before{width:530px;height:380px;bottom:-128px;left:calc(50% - 275px);background-size:530px 380px}.media-control{top:calc(50% - 48px);left:calc(50% - 48px)}.media-control svg{width:96px;height:96px}}.newsletter .section-paragraph{margin-bottom:32px}.newsletter-form{max-width:440px;margin:0 auto}@media (min-width: 641px){.newsletter .section-paragraph{margin-bottom:40px;padding-left:72px;padding-right:72px}}.is-boxed{background:#0b1524}.body-wrap{background:#06101F;overflow:hidden;display:flex;flex-direction:column;min-height:100vh}.boxed-container{max-width:1440px;margin:0 auto;box-shadow:0 16px 48px rgba(6,16,31,0.5)}main{flex:1 0 auto}.section-inner{position:relative;padding-top:48px;padding-bottom:48px}@media (min-width: 641px){.section-inner{padding-top:80px;padding-bottom:80px}}.site-footer{position:relative;font-size:14px;line-height:20px;letter-spacing:0px;color:#556B8B}.site-footer::before{content:"";position:absolute;bottom:0;left:calc(50% - 180px);width:297px;height:175px;background-image:url(data:image/svg+xml;base64,PHN2ZyB3aWR0aD0iMjk3IiBoZWlnaHQ9IjE3NSIgeG1sbnM9Imh0dHA6Ly93d3cudzMub3JnLzIwMDAvc3ZnIj4gIDxkZWZzPiAgICA8bGluZWFyR3JhZGllbnQgeDE9Ijk5LjQzNSUiIHkxPSI4NS4wNzglIiB4Mj0iOC42ODUlIiB5Mj0iMjMuNzMzJSIgaWQ9ImEiPiAgICAgIDxzdG9wIHN0b3AtY29sb3I9IiMxRDMwNEIiIG9mZnNldD0iMCUiLz4gICAgICA8c3RvcCBzdG9wLWNvbG9yPSIjMUQzMDRCIiBzdG9wLW9wYWNpdHk9IjAiIG9mZnNldD0iMTAwJSIvPiAgICA8L2xpbmVhckdyYWRpZW50PiAgPC9kZWZzPiAgPHBhdGggZD0iTTMxOC4xNzEgNzA4LjY0YzE2MC4wODYgMCA3MDIuNTI3LTIyOC4yNiAyODkuODYyLTI5MC00MTIuNjY2LTYxLjczOC0xMjkuNzc2LTI5MC0yODkuODYyLTI5MFMyOC4zMSAyNTguNDc5IDI4LjMxIDQxOC42NGMwIDE2MC4xNjMgMTI5Ljc3NSAyOTAgMjg5Ljg2MSAyOTB6IiB0cmFuc2Zvcm09InJvdGF0ZSgtNiAtOTUwLjAxNiAxMDU2LjE0MykiIGZpbGw9InVybCgjYSkiIGZpbGwtcnVsZT0iZXZlbm9kZCIvPjwvc3ZnPg==);background-repeat:no-repeat}.site-footer a{color:#556B8B;text-decoration:none}.site-footer a:hover,.site-footer a:active{text-decoration:underline}.site-footer-inner{position:relative;display:flex;flex-wrap:wrap;padding-top:48px;padding-bottom:48px}.footer-brand,.footer-links,.footer-social-links,.footer-copyright{flex:none;width:100%;display:inline-flex;justify-content:center}.footer-brand,.footer-links,.footer-social-links{margin-bottom:24px}.footer-links li+li,.footer-social-links li+li{margin-left:16px}.footer-social-links li{display:inline-flex}.footer-social-links li a{padding:8px}@media (min-width: 641px){.site-footer{margin-top:20px}.site-footer-inner{justify-content:space-between;padding-top:64px;padding-bottom:64px}.footer-brand,.footer-links,.footer-social-links,.footer-copyright{flex:50%}.footer-brand,.footer-copyright{justify-content:flex-start}.footer-links,.footer-social-links{justify-content:flex-end}.footer-links{order:1;margin-bottom:0}} </style> <script src="https://unpkg.com/scrollreveal@4.0.0/dist/scrollreveal.min.js"></script> </head> <body class="is-boxed has-animations"> <div class="body-wrap boxed-container"> <header class="site-header"> <div class="container"> <div class="site-header-inner"> <div class="brand header-brand"> <h1 class="m-0"> <a href="#"> <svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"> <title>Laurel</title> <defs> <linearGradient x1="0%" y1="100%" x2="50%" y2="0%" id="logo-a"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity=".16" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="logo-b"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M22 19.22c6.627 0 9.593-6.415 9.593-13.042C31.593-.45 28.627.007 22 .007S10 2.683 10 9.31c0 6.628 5.373 9.91 12 9.91z" fill="url(#logo-a)"/> <path d="M13.666 31.889c7.547 0 10.924-7.307 10.924-14.854 0-7.547-3.377-7.027-10.924-7.027C6.118 10.008 0 13.055 0 20.603c0 7.547 6.118 11.286 13.666 11.286z" fill="url(#logo-b)" transform="matrix(-1 0 0 1 24.59 0)"/> </g> </svg> </a> </h1> </div> </div> </div> </header> <main> <section class="hero"> <div class="container"> <div class="hero-inner"> <div class="hero-copy"> <h1 class="hero-title mt-0">Landing template for startups</h1> <p class="hero-paragraph">Our landing page template works on all devices, so you only have to set it up once, and get beautiful results forever.</p> <div class="hero-cta"><a class="button button-shadow" href="#">Learn more</a><a class="button button-primary button-shadow" href="#">Early access</a></div> </div> <div class="hero-app"> <div class="hero-app-illustration"> <svg width="999" height="931" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="92.827%" y1="0%" x2="53.422%" y2="80.087%" id="hero-shape-a"> <stop stop-color="#F9425F" offset="0%"/> <stop stop-color="#F97C58" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="92.827%" y1="0%" x2="53.406%" y2="80.12%" id="hero-shape-b"> <stop stop-color="#47A1F9" offset="0%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="80.532%"/> <stop stop-color="#FDFFDA" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="8.685%" y1="23.733%" x2="85.808%" y2="82.837%" id="hero-shape-c"> <stop stop-color="#FFF" stop-opacity=".48" offset="0%"/> <stop stop-color="#FFF" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="79.483%" y1="15.903%" x2="38.42%" y2="70.124%" id="hero-shape-d"> <stop stop-color="#47A1F9" offset="0%"/> <stop stop-color="#FDFFDA" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="99.037%" y1="26.963%" x2="24.582%" y2="78.557%" id="hero-shape-e"> <stop stop-color="#FDFFDA" stop-opacity=".64" offset="0%"/> <stop stop-color="#F97C58" stop-opacity=".24" offset="42.952%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <g class="hero-shape-top"> <g class="is-moving-object is-translating" data-translating-factor="280"> <path d="M680.188 0c-23.36 69.79-58.473 98.3-105.34 85.531-70.301-19.152-189.723-21.734-252.399 91.442-62.676 113.175-144.097 167.832-215.195 118.57C59.855 262.702 24.104 287.85 0 370.988L306.184 566.41c207.164-4.242 305.67-51.612 295.52-142.11-10.152-90.497 34.533-163.55 134.054-219.16l4.512-119.609L680.188 0z" fill="url(#hero-shape-a)" transform="translate(1)"/> </g> <g class="is-moving-object is-translating" data-translating-factor="100"> <path d="M817.188 222c-23.36 69.79-58.473 98.3-105.34 85.531-70.301-19.152-189.723-21.734-252.399 91.442-62.676 113.175-144.097 167.832-215.195 118.57-47.399-32.841-83.15-7.693-107.254 75.445L443.184 788.41c207.164-4.242 305.67-51.612 295.52-142.11-10.152-90.497 34.533-163.55 134.054-219.16l4.512-119.609L817.188 222z" fill="url(#hero-shape-b)" transform="rotate(-53 507.635 504.202)"/> </g> </g> <g transform="translate(191 416)"> <g class="is-moving-object is-translating" data-translating-factor="50"> <circle fill="url(#hero-shape-c)" cx="336" cy="190" r="190"/> </g> <g class="is-moving-object is-translating" data-translating-factor="80"> <path d="M683.766 133.043c-112.048-90.805-184.688-76.302-217.92 43.508-33.23 119.81-125.471 124.8-276.722 14.972-3.156 120.356 53.893 200.09 171.149 239.203 175.882 58.67 346.695-130.398 423.777-239.203 51.388-72.536 17.96-92.03-100.284-58.48z" fill="url(#hero-shape-d)"/> </g> <g class="is-moving-object is-translating" data-translating-factor="100"> <path d="M448.206 223.247c-97.52-122.943-154.274-117.426-170.26 16.55C261.958 373.775 169.717 378.766 1.222 254.77c-9.255 95.477 47.794 175.211 171.148 239.203 185.032 95.989 424.986-180.108 424.986-239.203 0-39.396-49.717-49.904-149.15-31.523z" fill="url(#hero-shape-e)" transform="matrix(-1 0 0 1 597.61 0)"/> </g> </g> </g> </svg> </div> <img class="device-mockup" src="dist/images/iphone-mockup.png" alt="App preview"> <div class="hero-app-dots hero-app-dots-1"> <svg width="124" height="75" xmlns="http://www.w3.org/2000/svg"> <g fill="none" fill-rule="evenodd"> <path fill="#FFF" d="M33.392 0l3.624 1.667.984 3.53-1.158 3.36L33.392 10l-3.249-1.639L28 5.196l1.62-3.674z"/> <path fill="#7487A3" d="M74.696 3l1.812.833L77 5.598l-.579 1.68L74.696 8l-1.624-.82L72 5.599l.81-1.837z"/> <path fill="#556B8B" d="M40.696 70l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L38 72.599l.81-1.837z"/> <path fill="#7487A3" d="M4.314 37l2.899 1.334L8 41.157l-.926 2.688L4.314 45l-2.6-1.31L0 41.156l1.295-2.94zM49.314 32l2.899 1.334.787 2.823-.926 2.688L49.314 40l-2.6-1.31L45 36.156l1.295-2.94z"/> <path fill="#556B8B" d="M99.696 56l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L97 58.599l.81-1.837zM112.696 37l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L110 39.599l.81-1.837zM82.696 37l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L80 39.599l.81-1.837zM122.618 57l1.087.5.295 1.059-.347 1.008-1.035.433-.975-.492-.643-.95.486-1.101z"/> </g> </svg> </div> <div class="hero-app-dots hero-app-dots-2"> <svg width="124" height="75" xmlns="http://www.w3.org/2000/svg"> <g fill="none" fill-rule="evenodd"> <path fill="#556B8B" d="M33.392 0l3.624 1.667.984 3.53-1.158 3.36L33.392 10l-3.249-1.639L28 5.196l1.62-3.674zM74.696 3l1.812.833L77 5.598l-.579 1.68L74.696 8l-1.624-.82L72 5.599l.81-1.837zM40.696 70l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L38 72.599l.81-1.837zM4.314 37l2.899 1.334L8 41.157l-.926 2.688L4.314 45l-2.6-1.31L0 41.156l1.295-2.94zM49.314 32l2.899 1.334.787 2.823-.926 2.688L49.314 40l-2.6-1.31L45 36.156l1.295-2.94z"/> <path fill="#FFF" d="M99.696 56l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L97 58.599l.81-1.837z"/> <path fill="#556B8B" d="M112.696 37l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L110 39.599l.81-1.837z"/> <path fill="#FFF" d="M82.696 37l1.812.833.492 1.765-.579 1.68-1.725.722-1.624-.82L80 39.599l.81-1.837z"/> <path fill="#556B8B" d="M122.618 57l1.087.5.295 1.059-.347 1.008-1.035.433-.975-.492-.643-.95.486-1.101z"/> </g> </svg> </div> </div> </div> </div> </section> <section class="features section"> <div class="container"> <div class="features-inner section-inner has-bottom-divider"> <h2 class="section-title mt-0">Bold features</h2> <div class="features-wrap"> <div class="feature is-revealing"> <div class="feature-inner"> <div class="feature-icon"> <svg width="64" height="64" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="0%" y1="100%" x2="50%" y2="0%" id="feature-1-a"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity=".16" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="feature-1-b"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M24 48H0V24C0 10.745 10.745 0 24 0h24v24c0 13.255-10.745 24-24 24" fill="url(#feature-1-a)"/> <path d="M40 64H16V40c0-13.255 10.745-24 24-24h24v24c0 13.255-10.745 24-24 24" fill="url(#feature-1-b)"/> </g> </svg> </div> <h3 class="feature-title mt-24">Discover</h3> <p class="text-sm mb-0">A pseudo-Latin text used in web design, layout, and printing in place of things to emphasise design.</p> </div> </div> <div class="feature is-revealing"> <div class="feature-inner"> <div class="feature-icon"> <svg width="68" height="64" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="0%" y1="100%" x2="50%" y2="0%" id="feature-2-a"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity=".16" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="feature-2-b"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M9.941 63.941v-24c0-13.255 10.745-24 24-24h24v24c0 13.255-10.745 24-24 24h-24z" fill="url(#feature-2-a)" transform="rotate(45 33.941 39.941)"/> <path d="M16 0v24c0 13.255 10.745 24 24 24h24V24C64 10.745 53.255 0 40 0H16z" fill="url(#feature-2-b)"/> </g> </svg> </div> <h3 class="feature-title mt-24">Discover</h3> <p class="text-sm mb-0">A pseudo-Latin text used in web design, layout, and printing in place of things to emphasise design.</p> </div> </div> <div class="feature is-revealing"> <div class="feature-inner"> <div class="feature-icon"> <svg width="64" height="64" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="50%" y1="100%" x2="50%" y2="43.901%" id="feature-3-a"> <stop stop-color="#F97059" stop-opacity=".798" offset="0%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="58.893%" y1="100%" x2="58.893%" y2="18.531%" id="feature-3-b"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="feature-3-c"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path fill="url(#feature-3-a)" opacity=".32" d="M0 24h64v40H0z"/> <path fill="url(#feature-3-b)" d="M40 24H24L0 64h64z"/> <path d="M10 10v22c0 12.15 9.85 22 22 22h22V32c0-12.15-9.85-22-22-22H10z" fill="url(#feature-3-c)" transform="rotate(45 32 32)"/> </g> </svg> </div> <h3 class="feature-title mt-24">Discover</h3> <p class="text-sm mb-0">A pseudo-Latin text used in web design, layout, and printing in place of things to emphasise design.</p> </div> </div> <div class="feature is-revealing"> <div class="feature-inner"> <div class="feature-icon"> <svg width="64" height="64" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="0%" y1="100%" x2="50%" y2="0%" id="feature-4-a"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity=".16" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="feature-4-b"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M24 64H0V40c0-13.255 10.745-24 24-24h24v24c0 13.255-10.745 24-24 24" fill="url(#feature-4-a)" transform="matrix(-1 0 0 1 48 0)"/> <path d="M40 48H16V24C16 10.745 26.745 0 40 0h24v24c0 13.255-10.745 24-24 24" fill="url(#feature-4-b)"/> </g> </svg> </div> <h3 class="feature-title mt-24">Discover</h3> <p class="text-sm mb-0">A pseudo-Latin text used in web design, layout, and printing in place of things to emphasise design.</p> </div> </div> <div class="feature is-revealing"> <div class="feature-inner"> <div class="feature-icon"> <svg width="64" height="64" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="0%" y1="100%" x2="50%" y2="0%" id="feature-5-a"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity=".16" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="feature-5-b"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M24 63H0V39c0-13.255 10.745-24 24-24h24v24c0 13.255-10.745 24-24 24" fill="url(#feature-5-a)" transform="matrix(-1 0 0 1 48 0)"/> <path d="M40 48H16V24C16 10.745 26.745 0 40 0h24v24c0 13.255-10.745 24-24 24" fill-opacity=".24" fill="url(#feature-5-a)" transform="matrix(-1 0 0 1 80 0)"/> <path d="M10.113 10.113v22c0 12.15 9.85 22 22 22h22v-22c0-12.15-9.85-22-22-22h-22z" fill="url(#feature-5-b)" transform="rotate(45 32.113 32.113)"/> </g> </svg> </div> <h3 class="feature-title mt-24">Discover</h3> <p class="text-sm mb-0">A pseudo-Latin text used in web design, layout, and printing in place of things to emphasise design.</p> </div> </div> <div class="feature is-revealing"> <div class="feature-inner"> <div class="feature-icon"> <svg width="64" height="64" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="feature-6-a"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> <linearGradient x1="58.893%" y1="100%" x2="58.893%" y2="18.531%" id="feature-6-b"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M24 48H0V24C0 10.745 10.745 0 24 0h24v24c0 13.255-10.745 24-24 24" fill="url(#feature-6-a)"/> <path fill-opacity=".64" fill="url(#feature-6-b)" d="M24 29.229h40V64H0z"/> </g> </svg> </div> <h3 class="feature-title mt-24">Discover</h3> <p class="text-sm mb-0">A pseudo-Latin text used in web design, layout, and printing in place of things to emphasise design.</p> </div> </div> </div> </div> </div> </section> <section class="media section"> <div class="container-sm"> <div class="media-inner section-inner"> <div class="media-header text-center"> <h2 class="section-title mt-0">Meet Laurel</h2> <p class="section-paragraph mb-0">Lorem ipsum is common placeholder text used to demonstrate the graphic elements of a document or visual presentation.</p> </div> <div class="media-canvas"> <svg width="800" height="450" viewBox="0 0 800 450" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="100%" y1="0%" x2="0%" y2="100%" id="media-canvas"> <stop stop-color="#06101F" offset="0%"/> <stop stop-color="#1D304B" offset="100%"/> </linearGradient> </defs> <rect width="800" height="450" rx="8" fill="url(#media-canvas)" fill-rule="evenodd"/> </svg> <div class="media-control"> <svg width="96" height="96" viewBox="0 0 96 96" xmlns="http://www.w3.org/2000/svg"> <defs> <linearGradient x1="87.565%" y1="15.873%" x2="17.086%" y2="80.538%" id="media-control"> <stop stop-color="#FFF" stop-opacity=".64" offset="0%"/> <stop stop-color="#FFF" offset="100%"/> </linearGradient> <filter x="-500%" y="-500%" width="1000%" height="1000%" filterUnits="objectBoundingBox" id="media-shadow"> <feOffset dy="16" in="SourceAlpha" result="shadowOffsetOuter"></feOffset> <feGaussianBlur stdDeviation="24" in="shadowOffsetOuter" result="shadowBlurOuter"></feGaussianBlur> <feColorMatrix values="0 0 0 0 0.024 0 0 0 0 0.064 0 0 0 0 0.12 0 0 0 0.24 0" in="shadowBlurOuter"></feColorMatrix> </filter> </defs> <g fill="none" fill-rule="evenodd"> <circle fill="#FFF" cx="48" cy="48" r="48" style="mix-blend-mode:multiply;filter:url(#media-shadow)"/> <circle fill="url(#media-control)" cx="48" cy="48" r="48"/> <path d="M44.6 39.2a1.001 1.001 0 0 0-1.6.8v18a1.001 1.001 0 0 0 1.6.8l12-9a.998.998 0 0 0 0-1.6l-12-9z" fill="#1D304B"/> </g> </svg> </div> </div> </div> </div> </section> <section class="newsletter section"> <div class="container-sm"> <div class="newsletter-inner section-inner"> <div class="newsletter-header text-center"> <h2 class="section-title mt-0">Stay in the know</h2> <p class="section-paragraph">Lorem ipsum is common placeholder text used to demonstrate the graphic elements of a document or visual presentation.</p> </div> <div class="footer-form newsletter-form field field-grouped"> <div class="control control-expanded"> <input class="input" type="email" name="email" placeholder="Your best email&hellip;"> </div> <div class="control"> <a class="button button-primary button-block button-shadow" href="#">Early access</a> </div> </div> </div> </div> </section> </main> <footer class="site-footer"> <div class="container"> <div class="site-footer-inner has-top-divider"> <div class="brand footer-brand"> <a href="#"> <svg width="32" height="32" viewBox="0 0 32 32" xmlns="http://www.w3.org/2000/svg"> <title>Laurel</title> <defs> <linearGradient x1="0%" y1="100%" x2="50%" y2="0%" id="logo-footer-a"> <stop stop-color="#F9425F" stop-opacity=".8" offset="0%"/> <stop stop-color="#47A1F9" stop-opacity=".16" offset="100%"/> </linearGradient> <linearGradient x1="50%" y1="100%" x2="50%" y2="0%" id="logo-footer-b"> <stop stop-color="#FDFFDA" offset="0%"/> <stop stop-color="#F97059" stop-opacity=".798" offset="49.935%"/> <stop stop-color="#F9425F" stop-opacity="0" offset="100%"/> </linearGradient> </defs> <g fill="none" fill-rule="evenodd"> <path d="M22 19.22c6.627 0 9.593-6.415 9.593-13.042C31.593-.45 28.627.007 22 .007S10 2.683 10 9.31c0 6.628 5.373 9.91 12 9.91z" fill="url(#logo-footer-a)"/> <path d="M13.666 31.889c7.547 0 10.924-7.307 10.924-14.854 0-7.547-3.377-7.027-10.924-7.027C6.118 10.008 0 13.055 0 20.603c0 7.547 6.118 11.286 13.666 11.286z" fill="url(#logo-footer-b)" transform="matrix(-1 0 0 1 24.59 0)"/> </g> </svg> </a> </div> <ul class="footer-links list-reset"> <li> <a href="#">Contact</a> </li> <li> <a href="#">About us</a> </li> <li> <a href="#">FAQs</a> </li> <li> <a href="#">Support</a> </li> </ul> <ul class="footer-social-links list-reset"> <li> <a href="#"> <span class="screen-reader-text">Facebook</span> <svg width="16" height="16" xmlns="http://www.w3.org/2000/svg"> <path d="M6.023 16L6 9H3V6h3V4c0-2.7 1.672-4 4.08-4 1.153 0 2.144.086 2.433.124v2.821h-1.67c-1.31 0-1.563.623-1.563 1.536V6H13l-1 3H9.28v7H6.023z" fill="#FFF"/> </svg> </a> </li> <li> <a href="#"> <span class="screen-reader-text">Twitter</span> <svg width="16" height="16" xmlns="http://www.w3.org/2000/svg"> <path d="M16 3c-.6.3-1.2.4-1.9.5.7-.4 1.2-1 1.4-1.8-.6.4-1.3.6-2.1.8-.6-.6-1.5-1-2.4-1-1.7 0-3.2 1.5-3.2 3.3 0 .3 0 .5.1.7-2.7-.1-5.2-1.4-6.8-3.4-.3.5-.4 1-.4 1.7 0 1.1.6 2.1 1.5 2.7-.5 0-1-.2-1.5-.4C.7 7.7 1.8 9 3.3 9.3c-.3.1-.6.1-.9.1-.2 0-.4 0-.6-.1.4 1.3 1.6 2.3 3.1 2.3-1.1.9-2.5 1.4-4.1 1.4H0c1.5.9 3.2 1.5 5 1.5 6 0 9.3-5 9.3-9.3v-.4C15 4.3 15.6 3.7 16 3z" fill="#FFF"/> </svg> </a> </li> <li> <a href="#"> <span class="screen-reader-text">Google</span> <svg width="16" height="16" xmlns="http://www.w3.org/2000/svg"> <path d="M7.9 7v2.4H12c-.2 1-1.2 3-4 3-2.4 0-4.3-2-4.3-4.4 0-2.4 2-4.4 4.3-4.4 1.4 0 2.3.6 2.8 1.1l1.9-1.8C11.5 1.7 9.9 1 8 1 4.1 1 1 4.1 1 8s3.1 7 7 7c4 0 6.7-2.8 6.7-6.8 0-.5 0-.8-.1-1.2H7.9z" fill="#FFF"/> </svg> </a> </li> </ul> <div class="footer-copyright">&copy; 2018 Laurel, all rights reserved</div> </div> </div> </footer> </div> <script > !function(){const t=window,e=document.documentElement;if(e.classList.remove("no-js"),e.classList.add("js"),document.body.classList.contains("has-animations")){const t=window.sr=ScrollReveal();t.reveal(".feature",{duration:600,distance:"20px",easing:"cubic-bezier(0.5, -0.01, 0, 1.005)",origin:"right",interval:100}),t.reveal(".media-canvas",{duration:600,scale:".95",easing:"cubic-bezier(0.5, -0.01, 0, 1.005)",viewFactor:.5})}const n=document.querySelector(".device-mockup");function i(){n.classList.add("has-loaded")}n.complete?i():n.addEventListener("load",i);const s=document.querySelector(".features"),a=s.querySelector(".section-title"),o=document.querySelector(".feature-inner");function r(){let t=s.querySelector(".features-inner").getBoundingClientRect().left,e=o.getBoundingClientRect().left,n=parseInt(e-t);a.style.marginLeft=e>t?`${n}px`:0}r(),t.addEventListener("resize",r);const c=document.querySelectorAll(".is-moving-object");let l=0,d=0,u=0,g=0,f=0,m=e.clientWidth,p=e.clientHeight;c&&t.addEventListener("mousemove",function(t,e){let n=null,i=e;return(...e)=>{let s=Date.now();(!n||s-n>=i)&&(n=s,t.apply(this,e))}}(function(e){!function(e,n){l=e.pageX,d=e.pageY,u=t.scrollY,g=m/2-l,f=p/2-(d-u);for(let t=0;t<n.length;t++){const e=n[t].getAttribute("data-translating-factor")||20,i=n[t].getAttribute("data-rotating-factor")||20,s=n[t].getAttribute("data-perspective")||500;let a=[];n[t].classList.contains("is-translating")&&a.push("translate("+g/e+"px, "+f/e+"px)"),n[t].classList.contains("is-rotating")&&a.push("perspective("+s+"px) rotateY("+-g/i+"deg) rotateX("+f/i+"deg)"),(n[t].classList.contains("is-translating")||n[t].classList.contains("is-rotating"))&&(a=a.join(" "),n[t].style.transform=a,n[t].style.transition="transform 1s ease-out",n[t].style.transformStyle="preserve-3d",n[t].style.backfaceVisibility="hidden")}}(e,c)},150))}(); </script> </body> </html>',
                'styles' => '',
                'status' => 1,
            ]
        ]);
    }
}
