import * as _dnd_kit_abstract from '@dnd-kit/abstract';
import { Sensor, Sensors as Sensors$1, Data, Draggable as Draggable$1, DraggableInput, Droppable as Droppable$1, DroppableInput, DragDropManager as DragDropManager$1, DragDropManagerInput, Modifiers, Plugins, DragDropEvents, Plugin, CorePlugin } from '@dnd-kit/abstract';
import { CollisionDetector } from '@dnd-kit/collision';
import { Distance, Coordinates, Shape } from '@dnd-kit/geometry';
import { CleanupFunction } from '@dnd-kit/state';

interface EventListenerDescriptor {
    type: string;
    listener(event: Event): void;
    options?: AddEventListenerOptions;
}
type EventListenerInput = EventListenerDescriptor[] | EventListenerDescriptor;
declare class Listeners {
    private entries;
    constructor();
    bind(target: EventTarget, input: EventListenerInput): () => void;
    clear: () => void;
}

type KeyCode = KeyboardEvent['code'];
type KeyboardCodes = {
    start: KeyCode[];
    cancel: KeyCode[];
    end: KeyCode[];
    up: KeyCode[];
    down: KeyCode[];
    left: KeyCode[];
    right: KeyCode[];
};
interface KeyboardSensorOptions {
    /**
     * The offset by which the keyboard sensor should move the draggable.
     *
     * @default 10
     */
    offset?: number | {
        x: number;
        y: number;
    };
    /**
     * The keyboard codes that activate the keyboard sensor.
     *
     * @default {
     *   start: ['Space', 'Enter'],
     *   cancel: ['Escape'],
     *   end: ['Space', 'Enter', 'Tab'],
     *   up: ['ArrowUp'],
     *   down: ['ArrowDown'],
     *   left: ['ArrowLeft'],
     *   right: ['ArrowRight']
     * }
     */
    keyboardCodes?: KeyboardCodes;
    /**
     * Function that determines if the keyboard sensor should activate.
     */
    shouldActivate?(args: {
        event: KeyboardEvent;
        source: Draggable;
        manager: DragDropManager;
    }): boolean;
}
/**
 * The KeyboardSensor class is an input sensor that handles Keyboard events.
 */
declare class KeyboardSensor extends Sensor<DragDropManager, KeyboardSensorOptions> {
    #private;
    manager: DragDropManager;
    options?: KeyboardSensorOptions | undefined;
    constructor(manager: DragDropManager, options?: KeyboardSensorOptions | undefined);
    protected listeners: Listeners;
    bind(source: Draggable, options?: KeyboardSensorOptions | undefined): () => void;
    protected handleSourceKeyDown: (event: KeyboardEvent, source: Draggable, options: KeyboardSensorOptions | undefined) => void;
    protected handleStart(event: KeyboardEvent, source: Draggable, options: KeyboardSensorOptions | undefined): void;
    protected handleKeyDown(event: KeyboardEvent, _source: Draggable, options: KeyboardSensorOptions | undefined): void;
    protected handleEnd(event: Event, canceled: boolean): void;
    protected handleMove(direction: 'up' | 'down' | 'left' | 'right', event: KeyboardEvent): void;
    private sideEffects;
    protected cleanup(): void;
    destroy(): void;
    static configure: (options: KeyboardSensorOptions) => _dnd_kit_abstract.PluginDescriptor<any, any, typeof KeyboardSensor>;
    static defaults: Readonly<Required<KeyboardSensorOptions>>;
}

interface DelayConstraint {
    value: number;
    tolerance: Distance;
}
interface DistanceConstraint {
    value: Distance;
    tolerance?: Distance;
}
interface ActivationConstraints {
    distance?: DistanceConstraint;
    delay?: DelayConstraint;
}
type Maybe<T> = T | undefined;
interface PointerSensorOptions {
    activationConstraints?: ActivationConstraints | ((event: PointerEvent, source: Draggable) => ActivationConstraints | undefined);
    activatorElements?: Maybe<Element>[] | ((source: Draggable) => Maybe<Element>[]);
}
/**
 * The PointerSensor class is an input sensor that handles Pointer events,
 * such as mouse, touch and pen interactions.
 */
declare class PointerSensor extends Sensor<DragDropManager, PointerSensorOptions> {
    #private;
    manager: DragDropManager;
    options?: PointerSensorOptions | undefined;
    protected listeners: Listeners;
    protected initialCoordinates: Coordinates | undefined;
    constructor(manager: DragDropManager, options?: PointerSensorOptions | undefined);
    protected activationConstraints(event: PointerEvent, source: Draggable): ActivationConstraints | undefined;
    bind(source: Draggable, options?: PointerSensorOptions | undefined): () => void;
    protected handlePointerDown(event: PointerEvent, source: Draggable, options?: PointerSensorOptions): void;
    private latest;
    protected handleMove: () => void;
    protected handlePointerMove(event: PointerEvent, source: Draggable): void;
    private handlePointerUp;
    protected handleKeyDown(event: KeyboardEvent): void;
    protected handleStart(source: Draggable, event: PointerEvent): void;
    protected handleCancel(event: Event): void;
    protected cleanup(): void;
    destroy(): void;
    static configure: (options: PointerSensorOptions) => _dnd_kit_abstract.PluginDescriptor<any, any, typeof PointerSensor>;
    static defaults: Readonly<PointerSensorOptions>;
}

type Sensors = Sensors$1<DragDropManager>;

type FeedbackType = 'default' | 'move' | 'clone' | 'none';
interface Input$2<T extends Data = Data> extends DraggableInput<T> {
    handle?: Element;
    element?: Element;
    feedback?: FeedbackType;
    sensors?: Sensors;
}
declare class Draggable<T extends Data = Data> extends Draggable$1<T, DragDropManager> {
    constructor({ element, effects, handle, feedback, ...input }: Input$2<T>, manager: DragDropManager | undefined);
    accessor handle: Element | undefined;
    accessor element: Element | undefined;
    accessor feedback: FeedbackType;
}

type OptionalInput = 'collisionDetector';
interface Input$1<T extends Data = Data> extends Omit<DroppableInput<T>, OptionalInput> {
    collisionDetector?: CollisionDetector;
    element?: Element;
}
declare class Droppable<T extends Data = Data> extends Droppable$1<T, DragDropManager> {
    #private;
    constructor({ element, effects, ...input }: Input$1<T>, manager: DragDropManager | undefined);
    accessor proxy: Element | undefined;
    set element(element: Element | undefined);
    get element(): Element | undefined;
    refreshShape: () => Shape | undefined;
}

interface Input extends DragDropManagerInput<DragDropManager> {
}
declare const defaultPreset: {
    modifiers: Modifiers<DragDropManager>;
    plugins: Plugins<DragDropManager>;
    sensors: Sensors$1<DragDropManager>;
};
declare class DragDropManager<T extends Data = Data, U extends Draggable<T> = Draggable<T>, V extends Droppable<T> = Droppable<T>> extends DragDropManager$1<U, V> {
    constructor(input?: Input);
}

type GetAnnouncementForEvent<Key extends keyof DragDropEvents<any, any, any>> = (event: Parameters<DragDropEvents<Draggable, Droppable, DragDropManager>[Key]>[0], manager: DragDropManager) => string | undefined;
interface Announcements {
    dragstart: GetAnnouncementForEvent<'dragstart'>;
    dragmove?: GetAnnouncementForEvent<'dragmove'>;
    dragover?: GetAnnouncementForEvent<'dragover'>;
    dragend: GetAnnouncementForEvent<'dragend'>;
}
interface ScreenReaderInstructions {
    draggable: string;
}

interface Options$1 {
    /**
     * Optional id that should be used for the accessibility plugin's screen reader instructions and announcements.
     */
    id?: string;
    /**
     * Optional id prefix to use for the accessibility plugin's screen reader instructions and announcements.
     */
    idPrefix?: {
        description?: string;
        announcement?: string;
    };
    /**
     * The announcements to use for the accessibility plugin.
     */
    announcements?: Announcements;
    /**
     * The screen reader instructions to use for the accessibility plugin.
     */
    screenReaderInstructions?: ScreenReaderInstructions;
    /**
     * The number of milliseconds to debounce the announcement updates.
     *
     * @remarks
     * Only the `dragover` and `dragmove` announcements are debounced.
     *
     * @default 500
     */
    debounce?: number;
}
declare class Accessibility extends Plugin<DragDropManager> {
    constructor(manager: DragDropManager, options?: Options$1);
}

interface CursorPluginOptions {
    /**
     * The style of the cursor to be applied to the document body.
     * @default 'grabbing'
     */
    cursor?: string;
}
declare class Cursor extends Plugin<DragDropManager> {
    manager: DragDropManager;
    constructor(manager: DragDropManager, options?: CursorPluginOptions);
}

interface FeedbackOptions {
    rootElement?: Element | ((source: Draggable) => Element);
}
declare class Feedback extends Plugin<DragDropManager, FeedbackOptions> {
    #private;
    accessor overlay: Element | undefined;
    private state;
    constructor(manager: DragDropManager, options?: FeedbackOptions);
    destroy(): void;
    static configure: (options: FeedbackOptions) => _dnd_kit_abstract.PluginDescriptor<any, any, typeof Feedback>;
}

interface Transition {
    /**
     * The duration of the transition in milliseconds.
     * @default 250
     */
    duration?: number;
    /**
     * The easing function to use for the transition.
     * @default 'ease-in-out'
     */
    easing?: string;
}

declare class Scroller extends CorePlugin<DragDropManager> {
    #private;
    getScrollableElements: () => Set<Element> | null;
    private scrollIntentTracker;
    accessor autoScrolling: boolean;
    constructor(manager: DragDropManager);
    scroll: (options?: {
        by: Coordinates;
    }) => boolean;
}

interface Options {
}
declare class AutoScroller extends Plugin<DragDropManager> {
    destroy: CleanupFunction;
    constructor(manager: DragDropManager, _options?: Options);
}

declare class ScrollListener extends CorePlugin<DragDropManager> {
    #private;
    constructor(manager: DragDropManager);
    private handleScroll;
}

declare class PreventSelection extends Plugin<DragDropManager> {
    manager: DragDropManager;
    constructor(manager: DragDropManager);
}

export { Accessibility, AutoScroller, Cursor, DragDropManager, type Input as DragDropManagerInput, Draggable, type Input$2 as DraggableInput, Droppable, type Input$1 as DroppableInput, Feedback, type FeedbackType, KeyboardSensor, PointerSensor, PreventSelection, ScrollListener, Scroller, type Sensors, type Transition, defaultPreset };
