import * as _dnd_kit_geometry from '@dnd-kit/geometry';
import { Alignment } from '@dnd-kit/geometry';
import { Data, UniqueIdentifier, PluginConstructor, Modifiers, CollisionPriority, Type, Plugin } from '@dnd-kit/abstract';
import { CollisionDetector } from '@dnd-kit/collision';
import { Draggable, Droppable, DraggableInput, DroppableInput, DragDropManager, FeedbackType, Sensors } from '@dnd-kit/dom';

interface SortableTransition {
    /**
     * The duration of the transition in milliseconds.
     * @default 300
     */
    duration?: number;
    /**
     * The easing function to use for the transition.
     * @default 'cubic-bezier(0.25, 1, 0.5, 1)'
     */
    easing?: string;
    /**
     * Whether the sortable item should transition when its index changes,
     * but there is no drag operation in progress.
     * @default false
     **/
    idle?: boolean;
}
interface SortableInput<T extends Data> extends DraggableInput<T>, DroppableInput<T> {
    /**
     * The index of the sortable item within its group.
     */
    index: number;
    /**
     * The element that should be used as the droppable target for this sortable item.
     */
    target?: Element;
    /**
     * The optional unique identifier of the group that the sortable item belongs to.
     */
    group?: UniqueIdentifier;
    /**
     * The transition configuration to use when the index of the sortable item changes.
     */
    transition?: SortableTransition | null;
    /**
     * Plugins to register when sortable item is instantiated.
     * @default [SortableKeyboardPlugin, OptimisticSortingPlugin]
     */
    plugins?: PluginConstructor[];
}
declare const defaultSortableTransition: SortableTransition;
declare class Sortable<T extends Data = Data> {
    #private;
    draggable: Draggable<T>;
    droppable: Droppable<T>;
    accessor index: number;
    get initialIndex(): number;
    get initialGroup(): UniqueIdentifier | undefined;
    accessor group: UniqueIdentifier | undefined;
    transition: SortableTransition | null;
    constructor({ effects: inputEffects, group, index, sensors, type, transition, plugins, ...input }: SortableInput<T>, manager: DragDropManager<any, any> | undefined);
    protected animate(): void;
    get manager(): DragDropManager<any, any> | undefined;
    set manager(manager: DragDropManager<any, any> | undefined);
    set element(element: Element | undefined);
    get element(): Element | undefined;
    set target(target: Element | undefined);
    get target(): Element | undefined;
    set source(source: Element | undefined);
    get source(): Element | undefined;
    get disabled(): boolean;
    set feedback(value: FeedbackType);
    set disabled(value: boolean);
    set data(data: T);
    set handle(handle: Element | undefined);
    set id(id: UniqueIdentifier);
    get id(): UniqueIdentifier;
    set sensors(value: Sensors | undefined);
    set modifiers(value: Modifiers | undefined);
    set collisionPriority(value: CollisionPriority | number | undefined);
    set collisionDetector(value: CollisionDetector | undefined);
    set alignment(value: Alignment | undefined);
    get alignment(): Alignment | undefined;
    set type(type: Type | undefined);
    get type(): Type | undefined;
    set accept(value: Droppable['accept']);
    get accept(): Droppable["accept"];
    get isDropTarget(): boolean;
    /**
     * A boolean indicating whether the sortable item is the source of a drag operation.
     */
    get isDragSource(): boolean;
    /**
     * A boolean indicating whether the sortable item is being dragged.
     */
    get isDragging(): boolean;
    /**
     * A boolean indicating whether the sortable item is being dropped.
     */
    get isDropping(): boolean;
    get status(): "idle" | "dragging" | "dropping";
    refreshShape(): _dnd_kit_geometry.Shape | undefined;
    accepts(draggable: Draggable): boolean;
    register: () => () => void;
    unregister: () => void;
    destroy: () => void;
}
declare class SortableDraggable<T extends Data> extends Draggable<T> {
    sortable: Sortable<T>;
    constructor(input: DraggableInput<T>, manager: DragDropManager | undefined, sortable: Sortable<T>);
    get index(): number;
}
declare class SortableDroppable<T extends Data> extends Droppable<T> {
    sortable: Sortable<T>;
    constructor(input: DraggableInput<T>, manager: DragDropManager | undefined, sortable: Sortable<T>);
}

declare function isSortable(element: Draggable | Droppable | null): element is SortableDroppable<any> | SortableDraggable<any>;

declare class OptimisticSortingPlugin extends Plugin<DragDropManager> {
    constructor(manager: DragDropManager);
}

declare class SortableKeyboardPlugin extends Plugin<DragDropManager> {
    constructor(manager: DragDropManager);
}

export { OptimisticSortingPlugin, Sortable, type SortableInput, SortableKeyboardPlugin, type SortableTransition, defaultSortableTransition, isSortable };
