import { Asset } from 'grapesjs';
import { ReactElement, JSX } from 'react';
import { PortalContainerResult } from './utils/react';
export type AssetsState = {
    /**
     * Array of assets.
     */
    assets: Asset[];
    /**
     * Asset types.
     */
    types: string[];
    /**
     * Select asset.
     */
    select: (asset: Asset, complete?: boolean) => void;
    /**
     * Close assets.
     */
    close: () => void;
    /**
     * Asset Manager container.
     */
    Container: PortalContainerResult;
};
export type AssetsResultProps = AssetsState & {
    /**
     * Indicates if the Asset Manager is open.
     */
    open: boolean;
};
export interface AssetsProviderProps {
    children: (props: AssetsResultProps) => ReactElement<any>;
}
export interface AssetsEventProps {
    open: boolean;
    assets: Asset[];
    types: string[];
    select: () => void;
    close: () => void;
    container: HTMLElement;
}
declare const _default: (props: AssetsProviderProps) => JSX.Element;
export default _default;
