import { SDKPluginOptions } from '../utils';
export interface AccordionComponentOptions extends SDKPluginOptions {
    /**
     * Additional Block properties of the accordion component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    block?: 'Block';
    /**
     * Additional Block properties of the group accordion component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    blockGroup?: 'Block';
    /**
     * SVG toolbar button icon to toggle the accordion open state.
     * You can pass an empty string to avoid adding the toolbar button.
     * @example
     * "<svg viewBox='0 0 24 24'><path d='M12 9a3 3 0..."
     */
    toolbarIconOpen?: string;
}
