import { SDKPluginOptions } from '../utils';
export interface AnimationComponentOptionsSchema extends SDKPluginOptions {
    /**
     * Additional Block properties of the animation component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    block?: 'Block';
    /**
     * Additional Block properties of the animation group component. Pass `false` to avoid adding the block.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    blockGroup?: 'Block';
    /**
     * Extend or update animation list.
     * @examples
     * animations: ({ items }) => {
     *  return [
     *    // Remove bounce animations
     *    ...items.filter(item => !item.id.startsWith('bounce')),
     *    // Add custom animation
     *    {
     *      id: 'animationId',
     *      name: 'Custom animation',
     *      css: '@keyframes animationId { 0% { opacity: 0; } 100% { opacity: 1; } }',
     *    }
     *  ]
     * }
     */
    animations?: '__fn__';
    /**
     * Initial style object of the animation component.
     * @example
     * { 'animation-duration': '0.5s' }
     */
    animationStyle?: {
        [key: string]: string;
    };
    /**
     * Initial style object of the animation group component.
     * @example
     * { '--stagger-delay': '0.5s' }
     */
    animationGroupStyle?: {
        [key: string]: string;
    };
}
