import { SDKPluginOptions } from '../utils';
export interface CanvasFullSizeOptions extends SDKPluginOptions {
    /**
     * Default max width for the devices.
     * @default 1200
     */
    deviceMaxWidth?: number;
    /**
     * Default min height for the devices.
     * @default 500
     */
    deviceMinHeigth?: number;
    /**
     * Offset for the canvas on the Y axis (margin between the canvas and content frame).
     * @default 30
     */
    canvasOffsetY?: number;
    /**
     * Offset for the canvas on the X axis (margin between the canvas and content frame).
     * @default 50
     */
    canvasOffsetX?: number;
    /**
     * Transition time for the canvas when the screen size changes (in seconds).
     * @default 0.3
     */
    canvasTransition?: number;
    /**
     * Border radius for the content frame (in px).
     * @default 5
     */
    frameBorderRadius?: number;
    /**
     * Transition time for the content frame when the device changes (in seconds).
     * @default 0.3
     */
    frameTransition?: number;
}
