import { FlexComponentOptions, FlexGetGapFnProps, FlexGetParentSizeFnProps, FlexGetSizeFnProps, FlexIsParentVerticalFnProps, FlexSetGapFnProps, FlexSetSizeFnProps } from './types';
export interface SizeHandler {
    getSize(props: FlexGetSizeFnProps): number;
    setSize(props: FlexSetSizeFnProps): void;
}
export interface GapHandler {
    getGap(props: FlexGetGapFnProps): number;
    setGap(props: FlexSetGapFnProps): void;
    isGapSupported(): boolean;
}
export interface ParentSizeHandler {
    getParentSize(props: FlexGetParentSizeFnProps): number;
    isLayoutVertical(props: FlexIsParentVerticalFnProps): boolean;
}
export declare function getHandlers(config: FlexComponentOptions): {
    sizeHandler: SizeHandler;
    gapHandler: GapHandler;
    parentSizeHandler: ParentSizeHandler;
};
