import { Component, Editor } from '../types';
import { FlexComponentOptions, ResizeDirection } from './types';
export declare class ComponentHandlerRegistry {
    private resizableChildTypes;
    private gapAdjustableParentTypes;
    private typeRelationships;
    registerResizableChild(childType: string): void;
    registerGapAdjustableParent(parentType: string): void;
    registerTypeRelationship(parentType: string, childType: string): void;
    isResizableChild(component: Component): boolean;
    isGapAdjustableParent(component: Component): boolean;
    isValidRelationship(parent: Component, child: Component): boolean;
}
export declare class ResizeHandler {
    private editor;
    private registry;
    private opts;
    private resizeState;
    constructor(editor: Editor, registry: ComponentHandlerRegistry, opts: FlexComponentOptions);
    private getState;
    private clearState;
    startResize(componentColumn: Component, direction: ResizeDirection, event: MouseEvent): void;
    updateResizeByDelta(component: Component, direction: ResizeDirection, delta: number): void;
    finishResize(column: Component): void;
    updateContinuesResize(componentColumn: Component, direction: ResizeDirection, delta: number): void;
    updateSnapResize(componentColumn: Component, direction: ResizeDirection, delta: number): void;
}
export declare class GapHandler {
    private editor;
    private registry;
    private opts;
    constructor(editor: Editor, registry: ComponentHandlerRegistry, opts: FlexComponentOptions);
    updateGapByDelta(componentRow: Component, delta: number, initialGapInPx: number, isVertical: boolean): void;
    finishGapAdjust(parentComponent: Component): void;
}
export declare class ComponentHandler {
    private editor;
    private registry;
    private opts;
    private resizeHandler;
    private gapHandler;
    constructor(editor: Editor, registry: ComponentHandlerRegistry, opts: FlexComponentOptions);
    startResize(component: Component, direction: ResizeDirection, event: MouseEvent): void;
    updateResizeByDelta(component: Component, direction: ResizeDirection, delta: number): void;
    finishResize(component: Component): void;
    updateGapByDelta(parentComponent: Component, delta: number, initialGapInPx: number, isVertical: boolean): void;
    finishGapAdjust(parentComponent: Component): void;
    canResize(component: Component): boolean;
    canAdjustGap(component: Component): boolean;
}
