import { BlockProperties, Component } from '../types';
import { FlexComponentOptions as FlexComponentOptionsSchema } from './typesSchema';
export interface FlexComponentOptions extends Omit<FlexComponentOptionsSchema, 'blocks' | 'getSize' | 'getGap' | 'getParentSize' | 'isParentVertical' | 'setSize' | 'setGap'> {
    blocks?: false | ((props: {
        blocks: BlockProperties[];
    }) => BlockProperties[]);
    getSize?: (props: FlexGetSizeFnProps) => number;
    getGap?: (props: FlexGetGapFnProps) => number;
    getParentSize?: (props: FlexGetParentSizeFnProps) => number;
    isParentVertical?: (props: FlexIsParentVerticalFnProps) => boolean;
    setSize?: (props: FlexSetSizeFnProps) => void;
    setGap?: (opts: FlexSetGapFnProps) => void;
}
export interface FlexGetSizeFnProps {
    componentColumn: Component;
    componentRow: Component;
    isVertical: boolean;
}
export interface FlexGetParentSizeFnProps extends Omit<FlexGetSizeFnProps, 'componentColumn'> {
}
export interface FlexIsParentVerticalFnProps extends Omit<FlexGetParentSizeFnProps, 'isVertical'> {
}
export interface FlexGetGapFnProps extends Omit<FlexGetSizeFnProps, 'componentColumn'> {
}
export interface FlexSetSizeFnProps extends FlexGetSizeFnProps {
    sizeValue: string;
    partial: boolean;
}
export interface FlexSetGapFnProps extends Omit<FlexSetSizeFnProps, 'sizeValue' | 'componentColumn' | 'isVertical'> {
    gapValue: string;
}
export type ResizeDirection = 'left' | 'right' | 'top' | 'bottom';
