import { ProjectType } from '@studio/editor/src/utils/types';
import { SDKPluginOptions } from '../utils';
export interface FlexComponentOptions extends SDKPluginOptions {
    /**
     * Filter default layout blocks. Pass `false` to avoid adding layout blocks.
     * @examples
     * ({ blocks }) => {
     *  // Remove the 1 Column block
     *  return blocks.filter(block => block.label !== '1 Column');
     * }
     */
    blocks?: 'Block';
    /**
     * Default component type for row.
     * @default 'flex-row'
     */
    typeRow?: string;
    /**
     * Default component type for column.
     * @default 'flex-column'
     */
    typeColumn?: string;
    /**
     * Indicate if the existant `typeRow` component has to be extended.
     * @default false
     */
    extendTypeRow?: boolean;
    /**
     * Indicate if the existant `typeColumn` component has to be extended.
     * @default false
     */
    extendTypeColumn?: boolean;
    /**
     * Minimum item percent size in percentage.
     * @default 5
     */
    minItemPercent?: number;
    /**
     * Enable snapping by default.
     * @default false
     */
    snapEnabled?: boolean;
    /**
     * Default divisions for snapping.
     * @default 12
     */
    snapDivisions?: number;
    /**
     * Disable gap handler.
     * @default false
     */
    disableGapHandler?: boolean;
    /**
     * Gap size in px.
     * @default 3
     */
    gapHandleSize?: number;
    /**
     * If you're using `email` project type in Studio SDK, you can set this option to `email` to active column resizing.
     * @default 'web'
     * @example "email"
     */
    projectType?: `${ProjectType}`;
    /**
     * Provide a custom handler for getting the column size.
     * @examples
     * ({ componentColumn }) => {
     *  return parseInt(componentColumn.getStyle()['flex-basis'], 10);
     * }
     */
    getSize?: '__fn__';
    /**
     * Provide a custom handler for getting the gap size.
     * @examples
     * ({ component }) => {
     *  return parseInt(component.getStyle()['gap'], 10);
     * }
     */
    getGap?: '__fn__';
    /**
     * Provide a custom handler for getting the parent size.
     * @examples
     * ({ component, isVertical }) => {
     *  return component.getEl().clientWidth || 0;
     * }
     */
    getParentSize?: '__fn__';
    /**
     * Provide a custom handler for checking if the parent layout is in vertical layout.
     * @examples
     * ({ component }) => {
     *  return true;
     * }
     */
    isParentVertical?: '__fn__';
    /**
     * Provide a custom handler for setting the column size.
     * @examples
     * ({ component, sizeValue, partial }) => {
     *  component.addStyle({ 'flex-basis': sizeValue }, { partial });
     * }
     */
    setSize?: '__fn__';
    /**
     * Provide a custom handler for setting the gap size.
     * @examples
     * ({ component, gapValue, partial }) => {
     *  component.addStyle({ gap: gapValue }, { partial });
     * }
     */
    setGap?: '__fn__';
}
