import { Component, Editor } from '../types';
import { ResizeDirection, FlexComponentOptions, FlexGetSizeFnProps, FlexGetGapFnProps, FlexGetParentSizeFnProps, FlexSetSizeFnProps, FlexSetGapFnProps } from './types';
export declare const hideEl: (el: HTMLElement) => void;
export declare const showEl: (el: HTMLElement) => void;
export declare const toFixedFloat: (num: number) => number;
export declare const isProjectEmail: (opts: FlexComponentOptions) => boolean;
export declare const disableFrameInteraction: (editor: Editor, disable: boolean) => void;
export declare const getResizeHandlesForLayout: (isParentVerticalLayout: boolean) => ResizeDirection[];
export declare const isFirstItemInParent: (component: Component) => boolean;
export declare const isLastItemInParent: (component: Component) => boolean;
export declare const isLastItemInParentWithSiblings: (component: Component) => boolean;
export declare const findNeighborIndex: (currentIndex: number, direction: ResizeDirection, isParentVerticalLayout: boolean, childCount: number) => number;
export declare const adjustChildrenCount: (parent: Component, targetCount: number) => void;
export declare const isVerticalResize: (direction: ResizeDirection) => boolean;
export declare const shouldHideHandle: (column: Component, direction: ResizeDirection) => boolean;
export declare const shouldShowGapAdjustHandle: (column: Component) => boolean;
export declare const isGrowing: (direction: ResizeDirection, delta: number) => boolean;
export declare const getCSSPropertyValue: <T extends string | number = string>(component: Component, property: string, isString?: boolean) => T;
export declare const getSpaceConsumedByNonChildrenInPx: (componentRow: Component, isVertical: boolean, config: FlexComponentOptions) => number;
export declare const isParentVerticalLayout: (componentRow: Component, config: FlexComponentOptions) => boolean;
export declare const getSizeValue: (props: FlexGetSizeFnProps, config: FlexComponentOptions) => number;
export declare const getGapInPx: (props: FlexGetGapFnProps, config: FlexComponentOptions) => number;
export declare const getParentSizeInPx: (props: FlexGetParentSizeFnProps, config: FlexComponentOptions) => number;
export declare const applyComponentSize: (props: FlexSetSizeFnProps, config: FlexComponentOptions) => void;
export declare const commitComponentSize: (props: FlexGetSizeFnProps, config: FlexComponentOptions) => void;
export declare const applyGapSize: (props: FlexSetGapFnProps, config: FlexComponentOptions) => void;
export declare const commitGapSize: (componentRow: Component, config: FlexComponentOptions) => void;
/**
 * Applies a ratio-based layout to an existing layout component
 * @param layoutComponent The parent layout component
 * @param ratioString A string like "3-3-3" or "2-6-4" representing child element ratios
 * @param gapValue The gap size (default: 2%)
 * @param config Optional configuration for style application
 */
export declare function applyLayoutRatio(props: {
    component: Component;
    ratio: string;
    gap: number;
    config: FlexComponentOptions;
}): void;
/**
 * Apply a preset layout from predefined options
 * @param layoutComponent The parent layout component
 * @param preset One of the predefined layout presets
 * @param config Optional configuration for style application
 */
export declare function applyPresetLayout(props: {
    component: Component;
    preset: string;
    config: FlexComponentOptions;
}): void;
export declare function calculateAndApplySizes(props: {
    component: Component;
    ratios: number[];
    gap: number;
    config: FlexComponentOptions;
}): void;
export declare function createEqualColumns({ count, ...rest }: {
    component: Component;
    count: number;
    gap: number;
    config: FlexComponentOptions;
}): void;
