import { SetAttrOptions } from 'grapesjs';
import { SDKPluginOptions } from '../utils';
export interface FsLightboxComponentOptions extends SDKPluginOptions {
    /**
     * Block options for the component. See https://grapesjs.com/docs/api/block.html#properties for more information.
     * @example
     * { category: 'Extra', label: 'My label' }
     */
    block?: object | false;
    /**
     * SVG toolbar button icon for opening the lightbox.
     * You can pass an empty string to avoid adding the toolbar button.
     * @example
     * '<svg viewBox="0 0 24 24"><path d="M12 9a3 3 0...'
     */
    toolbarIconOpen?: string;
    /**
     * Default source for the lightbox component.
     * @example
     * 'https://placehold.co/300/777/white.png?text=Image'
     */
    defaultSrc?: string;
    /**
     * CDN script to load dynamically in case the library is not available.
     * @example
     * 'https://cdn.jsdelivr.net/npm/fslightbox@3.4.2/index.js'
     */
    cdnScript?: string;
}
export interface AdjustOptions extends SetAttrOptions {
    adjust?: boolean;
}
export interface ComponentWindow extends Window {
    refreshFsLightbox?: () => void;
    fsLightboxInstances?: Record<string, any>;
    _isEditor?: boolean;
}
