import { StudioTraitProperties } from '@studio/editor/src/typeConfigs/components';
import { Component, TraitProperties } from 'grapesjs';
type TraitProps = Record<string, Partial<StudioTraitProperties>>;
export declare enum SourceTypes {
    image = "image",
    video = "video",
    external = "external"
}
export declare const typeMain = "lightGallery";
export declare const typeItem = "lightGallery-item";
export declare const ATTR_CMP = "data-lightgallery";
export declare const ATTR_CMP_ITEM = "data-lightgallery-item";
export declare const TOGGLE_BTN_ID = "toggle";
export declare const customIcons: {
    image: string;
    video: string;
    gallery: string;
    galleryItem: string;
    external: string;
    eye: string;
};
export declare const emptyTraitProps: ReturnType<typeof getTraitProps>;
export declare const getTraitProps: (traitProps: TraitProps, opts?: {
    category?: StudioTraitProperties["category"];
}) => {
    propKeys: string[];
    props: Record<string, any>;
    traits: StudioTraitProperties[];
};
export declare const updateSubTraits: (cmp: Component, traitId: string) => void;
export declare const initTraitsWithSubTraits: (cmp: Component, traitIds: string[]) => void;
export declare const initScriptUpdateOnSubTraitChanges: (cmp: Component, traitId: string, upFn: () => void) => void;
export declare const coreTraits: Record<string, Partial<StudioTraitProperties>>;
export declare const thumbnailsTraits: Record<string, Partial<StudioTraitProperties>>;
export declare const autoplayTraits: Record<string, Partial<StudioTraitProperties>>;
export declare const zoomTraits: Record<string, Partial<StudioTraitProperties>>;
export declare const itemSourceTypeName = "sourceType";
export declare const itemCustomThumbName = "data-external-thumb-image";
export declare const itemExternalName = "data-iframe";
export declare const traitSourceImage: TraitProperties;
export declare const traitSourceVideo: TraitProperties;
export declare const traitPoster: TraitProperties;
export declare const traitSourceExternal: TraitProperties;
export declare const traitCaption: TraitProperties;
export declare const traitCustomThumb: TraitProperties;
export declare const itemTraits: Record<string, Partial<StudioTraitProperties>>;
export {};
