import { Editor } from 'grapesjs';
import { MarkType, Node } from 'prosemirror-model';
import { Command, EditorState, Transaction } from 'prosemirror-state';
import { EditorView } from 'prosemirror-view';
import { CustomRteOptions } from './types';
export declare const handleEnter: (state: EditorState, dispatch?: (tr: Transaction) => void) => boolean;
export declare function handleShiftEnter(state: EditorState, dispatch?: (tr: Transaction) => void): boolean;
export declare function setAlignment(view: EditorView, alignment: string, force?: boolean): void;
export declare const markIsActiveAcrossSelection: (state: EditorState, markType: MarkType) => boolean;
export declare function setLink(view: EditorView, href: string, target?: string): void;
export declare function setFontSize(view: EditorView, size: string): void;
export declare const getClosestParentNode: (view: EditorView, predicate: (node: Node) => boolean) => {
    pos: number;
    start: number;
    depth: number;
    node: Node;
} | undefined;
export declare const cssStringToCssObject: (cssString: string) => Record<string, string>;
export declare const cssObjectToCssString: (cssObject: Record<string, string>) => string;
export declare function chainCommands(...commands: Command[]): Command;
export declare const focusCursor: (view: EditorView, opts?: CustomRteOptions) => void;
export declare const getCommands: (view: EditorView, editor: Editor) => {
    text: {
        selected: () => string;
        replace: (newText: string, opts?: {
            select?: boolean;
        }) => void;
    };
    bold: {
        toggle: () => boolean;
        isActive: () => boolean;
    };
    italic: {
        toggle: () => boolean;
        isActive: () => boolean;
    };
    underline: {
        toggle: () => boolean;
        isActive: () => boolean;
    };
    strikethrough: {
        toggle: () => boolean;
        isActive: () => boolean;
    };
    link: {
        get: () => any;
        toggle: () => boolean;
        isActive: () => boolean;
        create: (props: {
            url: string;
            target?: string;
        }) => void;
    };
    alignText: {
        get: () => string;
        set: (props: {
            value: string;
        }) => void;
    };
    fontSize: {
        get: () => string;
        set: (props: {
            value: string;
        }) => void;
    };
    image: {
        open(): void;
    };
    heading: {
        get: () => string;
        set: ({ value }: {
            value: string;
        }) => void;
    };
    listBullet: {
        isActive: () => boolean;
        toggle: () => boolean;
    };
    listOrdered: {
        isActive: () => boolean;
        toggle: () => boolean;
    };
};
export type BuiltInCommands = ReturnType<typeof getCommands>;
