import { RteProseMirrorOptions } from './types';
export interface RteProseMirrorOptionsSchema extends Omit<RteProseMirrorOptions, 'schema' | 'plugins' | 'toolbar'> {
    /**
     * Extend the default ProseMirror schema.
     * @examples
     * ({ schema }) => {
     *  // add additional nodes and return a new schema
     *  return new Schema({
     *    nodes: schema.spec.nodes.append({...}),
     *    marks: schema.spec.marks
     *  });
     * }
     */
    schema?: '__fn__';
    /**
     * Pass additional ProseMirror plugins.
     * @examples
     * ({ plugins }) => [
     *    // use the default plugins
     *    ...plugins,
     *    // pass your plugins
     *  ]
     */
    plugins?: '__fn__';
    /**
     * Customize the toolbar items.
     * @examples
     * toolbar({ items, component, proseMirror }) {
     *    const { view } = proseMirror;
     *    return [
     *      // use the default toolbar items
     *      ...items,
     *      {
     *        id: 'customButton',
     *        type: 'button',
     *        icon: 'flare',
     *        onClick: () => {...}
     *      }
     *    ];
     *  }
     */
    toolbar?: '__fn__';
}
