import { MarkType, NodeType } from 'prosemirror-model';
import { EditorState, Transaction } from 'prosemirror-state';
import { EditorView } from 'prosemirror-view';
import { Component, Editor } from 'grapesjs';
import { RteProseMirrorOptions } from './types';
export declare const mapElToView: WeakMap<HTMLElement, EditorView>;
export declare const mapViewToEl: WeakMap<EditorView, HTMLElement>;
export declare const setElToViewMapping: (el: HTMLElement, view: EditorView) => void;
export declare const deleteElToViewMapping: (el: HTMLElement, view: EditorView) => void;
export declare const getViewFromEl: (el: HTMLElement) => EditorView | undefined;
export declare const getElFromView: (view: EditorView) => HTMLElement | undefined;
/**
 * Get the GrapesJS component from the PM view
 */
export declare const getComponentFromView: (view: EditorView) => Component | undefined;
export declare const dispatchInput: (el: HTMLElement) => boolean;
export declare const isMarkActive: (state: EditorState, type: MarkType | null | undefined) => boolean;
export declare const isBlockActive: (state: EditorState, type: NodeType | null | undefined, attrs?: Record<string, any>) => boolean;
export declare function unwrapInlineFragment(container: HTMLElement): void;
export declare function updateNodeAttributes(tr: Transaction, pos: number, newAttrs: Record<string, any>): void;
export declare function handleNodeSplitting(tr: Transaction, from: number): {
    splittedElementPos: number;
    splittedInlineFragmentPos: number;
};
export declare function removeInlineFragmentMarks(tr: Transaction, pos: number, textLength: number): void;
export declare function enableRteOnClick(editor: Editor, options?: RteProseMirrorOptions): () => void;
