export interface Asset {
    type?: string;
    src?: string;
    unitDim?: string;
    height?: number;
    width?: number;
    [key: string]: any;
}
export interface Rule {
    selectors?: string[] | string;
    style?: Record<string, any>;
    mediaText?: string;
    atRuleType?: string;
    state?: string;
    group?: string;
    wrapper?: number;
    [key: string]: any;
}
export interface SymbolData {
    [key: string]: any;
}
export interface DataSource {
    [key: string]: any;
}
export interface HeadDefinition {
    type?: string;
    [key: string]: any;
}
export interface DocElDefinition {
    tagName?: string;
    [key: string]: any;
}
export interface ComponentDefinition {
    id?: string;
    type?: string;
    tagName?: string;
    attributes?: Record<string, any>;
    style?: Record<string, any>;
    content?: string;
    components?: ComponentDefinition[];
    head?: ComponentDefinition;
    docEl?: DocElDefinition;
    classes?: Array<string | {
        name: string;
        [key: string]: any;
    }>;
    [key: string]: any;
}
export interface FrameDefinition {
    component?: ComponentDefinition;
    width?: string;
    height?: string;
    [key: string]: any;
}
export interface PageDefinition {
    id?: string;
    name?: string;
    frames?: FrameDefinition[];
    [key: string]: any;
}
export interface ProjectDefinition {
    assets?: Asset[];
    styles?: Rule[];
    pages?: PageDefinition[];
    symbols?: SymbolData[];
    dataSources?: DataSource[];
    [key: string]: any;
}
export declare class ComponentNode {
    private data;
    constructor(data: ComponentDefinition);
    getId(): string | undefined;
    getType(): string | undefined;
    getTagName(): string;
    isVoid(): boolean;
    getAttributes(): Record<string, any>;
    getStyle(): Record<string, any>;
    getContent(): string;
    getComponents(): ComponentNode[];
    getHead(): ComponentNode | null;
    getDocEl(): DocElDefinition | undefined;
    getClasses(): string[];
    hasClass(className: string): boolean;
}
export declare class Frame {
    private data;
    constructor(data: FrameDefinition);
    getComponent(): ComponentNode | null;
    getWidth(): string;
    getHeight(): string;
}
export declare class Page {
    private data;
    constructor(data: PageDefinition);
    getId(): string | undefined;
    getName(): string;
    getFrames(): Frame[];
}
export declare class AssetManager {
    private assets;
    constructor(assets: Asset[]);
    getAll(): Asset[];
}
export declare class CssComposer {
    private rules;
    constructor(rules: Rule[]);
    getAll(): Rule[];
    getRulesByGroup(g: string): Rule[];
    getWrapperRules(): Rule[];
    getCssAsString(): string;
}
export declare class SymbolsManager {
    private symbols;
    constructor(symbols: SymbolData[]);
    getAll(): SymbolData[];
}
export declare class DataSourceManager {
    private list;
    constructor(list: DataSource[]);
    getAll(): DataSource[];
}
export declare class Pages {
    private pages;
    constructor(pages: PageDefinition[]);
    getAll(): Page[];
}
export declare class Editor {
    private assetManager;
    private cssComposer;
    private pages;
    private symbols;
    private dataSources;
    constructor(data: ProjectDefinition);
    getAssetManager(): AssetManager;
    getCssComposer(): CssComposer;
    getPages(): Pages;
    getSymbols(): SymbolsManager;
    getDataSources(): DataSourceManager;
}
export declare function findComponentById(root: ComponentNode, id: string): ComponentNode | null;
