import { CanvasConfig } from 'grapesjs';
import { createRoot } from 'react-dom/client';
import { CustomRendererReactConfig } from './shared/types';
import { ReactRendererPluginOptionsSchema } from './typesSchema';
declare global {
    interface Window {
        __reactRoot?: ReturnType<typeof createRoot>;
    }
    namespace JSX {
        interface IntrinsicElements {
            'gjs-wrapper': React.DetailedHTMLProps<React.HTMLAttributes<HTMLElement>, HTMLElement>;
        }
    }
}
type CustomRenderer = Parameters<Required<CanvasConfig>['customRenderer']>[0];
export interface CustomRendererProps extends CustomRenderer {
    config: ReactRendererPluginOptions;
}
export interface ReactRendererPluginOptions extends Omit<ReactRendererPluginOptionsSchema, 'components' | 'errors' | 'wrapper'>, CustomRendererReactConfig {
}
export {};
