import { SDKPluginOptions } from '../utils';
/**
 * Public schema for reactRenderer plugin options.
 */
export interface ComponentConfigSchema {
    /**
     * The React component to render.
     * @example '__component__'
     */
    component: '__component__';
    /**
     * Function to provide props.
     * @example '__fn__'
     */
    props?: '__fn__';
    /**
     * Model definition for the component.
     */
    model?: object;
    /**
     * Custom editor render function.
     * @example '__fn__'
     */
    editorRender?: '__fn__';
}
export type ErrorParamsSchema = {
    noPagesFound: object;
    pageNotFound: {
        pageId?: string;
    };
    noFramesFound: object;
    missingRootComponent: object;
    componentNotFound: {
        componentId: string;
    };
};
export type ErrorHandlerSchema<T extends keyof ErrorParamsSchema> = string | ((params: ErrorParamsSchema[T]) => string);
export type ErrorRenderersSchema = {
    [K in keyof ErrorParamsSchema]?: ErrorHandlerSchema<K>;
};
export interface CustomRendererReactConfigSchema {
    /**
     * Map of component type names to their configuration schemas.
     */
    components: Record<string, ComponentConfigSchema>;
    /**
     * Optional map of error types to their handlers.
     */
    errors?: ErrorRenderersSchema;
    /**
     * Optional custom wrapper React component.
     * Should be a reference or identifier in config UIs.
     */
    wrapper?: '__component__';
    /**
     * If true, skips rendering the document type.
     */
    skipDocType?: boolean;
}
export interface ReactRendererPluginOptionsSchema extends SDKPluginOptions {
    /**
     * Map of custom components
     */
    components?: object;
    /**
     * Map of custom error handlers
     */
    errors?: object;
    /**
     * Custom wrapper component
     */
    wrapper?: '__fn__';
    /**
     * If true, skips rendering the document type in HTML.
     */
    skipDocType?: boolean;
}
