import { Editor as EditorTinyMCE, RawEditorOptions, TinyMCE } from 'tinymce';
import { Component, ComponentView, Editor, RteCustomToolbarProps } from '../types';
import { RteTinyMceOptions as RteTinyMceOptionsSchema } from './typesSchema';
export type { Editor as EditorTinyMCE, RawEditorOptions } from 'tinymce';
export interface RteTinyMceOptions extends Omit<RteTinyMceOptionsSchema, 'loadConfig'> {
    /**
     * Pass your custom configuration to the TinyMCE editor.
     * @example
     * ({ config, editor, component }) => {
     *  return {
     *   toolbar: 'bold italic underline strikethrough',
     *   // ...
     *  }
     * }
     */
    loadConfig?: (props: {
        config: RawEditorOptions;
        editor: Editor;
        component: Component;
        componentView: ComponentView;
    }) => RawEditorOptions;
}
export interface CustomRteOptions extends RteCustomToolbarProps {
    event?: PointerEvent;
    view: ComponentView;
}
export interface EditorDataTinyMCE {
    rteEditor: EditorTinyMCE;
    rteEditorShallow: EditorTinyMCE;
}
export interface HTMLElementWithSwiper extends HTMLElement {
    __onLoad?: (swiper: any) => void;
    __activeSlide?: number;
    __inPreview?: boolean;
}
declare global {
    interface Window {
        tinymce: TinyMCE;
    }
}
