import { SDKPluginOptions } from '../utils';
export interface RteTinyMceOptions extends SDKPluginOptions {
    /**
     * CDN scripts to load dynamically in case the library is not available.
     * @default "https://cdn.jsdelivr.net/npm/tinymce@6.8.5/tinymce.min.js"
     */
    cdnScript?: string;
    /**
     * Enable RTE on click of the text component, instead of the default double-click.
     * @default false
     */
    enableOnClick?: boolean;
    /**
     * Skip adding custom CSS styles for the toolbar based on the Studio theme.
     * @default false
     */
    skipCustomTheme?: boolean;
    /**
     * Pass your custom configuration to the TinyMCE editor.
     * @examples
     * ({ config, editor, component }) => {
     *  return {
     *   toolbar: 'bold italic underline strikethrough',
     *   // ...
     *  }
     * }
     */
    loadConfig?: '__fn__';
}
