import { Component } from 'grapesjs';
interface TableGridItem {
    real: boolean;
    cell: Component;
    rowspan: number;
    colspan: number;
}
interface TableCellPos {
    x: number;
    y: number;
}
type TableGrid = TableGridItem[][];
export declare const getSpanValues: (cell: Component) => {
    rowspan: number;
    colspan: number;
};
export declare function buildGrid(rowParent: Component): TableGrid;
export declare function getCell(grid: TableGrid, x: number, y: number): TableGridItem | undefined;
export declare function split(grid: TableGrid): void;
export declare const buildGridWithPos: (rowParent: Component, opts?: {
    selected?: Component[];
}) => {
    grid: TableGrid;
    startPos: TableCellPos | undefined;
    endPos: TableCellPos | undefined;
};
export declare function merge(rowParent: Component, opts?: {
    mergeContent?: boolean;
}): void;
export {};
