import { Component, Editor, ObjectAny } from 'grapesjs';
import { SDKPluginOptions } from '../utils';
import { LayoutCommandProps } from '@studio/editor/src/types';
export { StudioCommands } from '@studio/editor/src/plugins/global/types';
export type { LayoutCommandProps, ContextMenuItem, ContextMenuFn } from '@studio/editor/src/types';
export interface GetTableContextItems {
    editor: Editor;
    component: Component;
    opts: TableComponentOptions;
}
export interface OpenSettingsProps extends GetTableContextItems {
    event: MouseEvent;
}
export interface TableComponentOptions extends SDKPluginOptions {
    /**
     * Block options for the table component. See https://grapesjs.com/docs/api/block.html#properties for more information.
     * @example
     * { category: 'Extra', label: 'My Table' }
     */
    block?: ObjectAny | false;
    /**
     * Customize the layout for table component setting actions, which by default are shown in a popover.
     * @example
     * ({ editor, layoutProps }) => {
     *   // open settings in a dialog
     *   editor.runCommand('studio:layoutToggle', {
     *     ...layoutProps,
     *     header: false,
     *     style: { marginLeft: -20, marginRight: -20 },
     *     placer: { type: 'dialog', title: layoutProps.header?.label },
     *   });
     * }
     */
    openSettings?: (props: OpenSettingsProps & {
        layoutProps: LayoutCommandProps;
    }) => void;
}
export declare enum TableContextMenuItem {
    table = "table",
    tableSettings = "tableSettings",
    tableDelete = "tableDelete",
    tableHead = "tableHead",
    tableFoot = "tableFoot",
    tableCellItems = "tableCellItems",
    tableCellProperties = "tableCellProperties",
    tableCellMerge = "tableCellMerge",
    tableCellSplit = "tableCellSplit",
    tableRowItems = "tableRowItems",
    tableRowInsertBefore = "tableRowInsertBefore",
    tableRowInsertAfter = "tableRowInsertAfter",
    tableRowDelete = "tableRowDelete",
    tableRowProperties = "tableRowProperties",
    tableRowCut = "tableRowCut",
    tableRowCopy = "tableRowCopy",
    tableRowPasteBefore = "tableRowPasteBefore",
    tableRowPasteAfter = "tableRowPasteAfter",
    tableColumn = "tableColumn",
    tableColumnItems = "tableColumnItems",
    tableColumnInsertBefore = "tableColumnInsertBefore",
    tableColumnInsertAfter = "tableColumnInsertAfter",
    tableColumnDelete = "tableColumnDelete",
    tableColumnCut = "tableColumnCut",
    tableColumnCopy = "tableColumnCopy",
    tableColumnPasteBefore = "tableColumnPasteBefore",
    tableColumnPasteAfter = "tableColumnPasteAfter"
}
export declare const tableIcons: Record<TableContextMenuItem, string>;
