import { TableComponentOptions, TableContextMenuItem } from './types';
export interface TableComponentOptionsSchema extends Omit<TableComponentOptions, 'openSettings'> {
    /**
     * Customize the layout for table component setting actions, which by default are shown in a popover.
     * @examples
     * ({ editor, layoutProps }) => {
     *   // open settings in a dialog
     *   editor.runCommand('studio:layoutToggle', {
     *     ...layoutProps,
     *     header: false,
     *     style: { marginLeft: -20, marginRight: -20 },
     *     placer: { type: 'dialog', title: layoutProps.header?.label },
     *   });
     * }
     */
    openSettings?: '__fn__';
}
export type TableContextMenuItemSchema = TableContextMenuItem;
