import { Component, Editor } from 'grapesjs';
import { LayoutCommandProps, OpenSettingsProps } from './types';
export declare const typeTable = "table";
export declare const typeHead = "thead";
export declare const typeFoot = "tfoot";
export declare const typeBody = "tbody";
export declare const typeRow = "row";
export declare const typeCell = "cell";
export declare const keyClipboard = "clipboardTable";
export declare const tableTypes: string[];
export interface WithAfter {
    after?: boolean;
}
export interface WithOpts {
    opts?: Record<string, any>;
}
export declare const getClipboardCmps: (editor: Editor) => Component[];
export declare const hasAllCells: (cmps: Component[]) => boolean;
export declare const openSettings: (props: OpenSettingsProps, layout: Pick<LayoutCommandProps, "id" | "header">) => void;
export declare const createTableSection: (type: string, { rows, cells, text }?: {
    rows?: number;
    cells?: number;
    text?: string | ((props: {
        x: number;
        y: number;
    }) => string);
}) => {
    type: string;
    components: {
        type: string;
        components: {
            type: string;
            components: {
                type: string;
                content: string;
            } | undefined;
        }[];
    }[];
};
