export interface GradientPickerProps {
    className?: string;
    value: string;
    onChange?(value: string, partial?: boolean): void;
}
export type Orientation = {
    type: string;
    value?: string;
    shape?: string;
    size?: {
        x: string;
        y: string;
    };
    position?: {
        x: string;
        y: string;
    };
};
export type ColorStop = {
    color: string;
    hint: number | null;
};
export type Selection = {
    stop: ColorStop;
    x: number;
    y: number;
    w: number;
    h: number;
};
/**
 * <linear-gradient()> = linear-gradient([ <angle> | to <side-or-corner> ]? , <color-stop-list>)
 * <radial-gradient()> = radial-gradient([ <ending-shape> || <size> ]? [ at <position> ]? , <color-stop-list>
 * @example
 * linear-gradient(90deg, rgba(18, 215, 151, 0.75) 31.25%, white 85.1562%)
 * linear-gradient(to bottom left, rgba(18, 215, 151, 0.75) 31.25%, white 85.1562%)
 * radial-gradient(#e66465, #9198e5)
 * radial-gradient(closest-side, #3f87a6, #ebf8e1, #f69d3c)
 * radial-gradient(circle at 100%, #333, #333 50%, #eee 75%, #333 75%)
 * radial-gradient(at top, #333, #333 50%, #eee 75%, #333 75%)
 * radial-gradient(20px at top, #333, #333 50%, #eee 75%, #333 75%)
 * radial-gradient(ellipse at top, #e66465, transparent)
 */
export declare const parseGradient: (input: string) => {
    name: string;
    orientation: Orientation;
    colorStops: ColorStop[];
};
/**
 * Spec: https://www.w3.org/TR/css-backgrounds-3/
 * bg-layer: <bg-image> || <bg-position> [ / <bg-size> ]? || <repeat-style> || <attachment> || <box> || <box>
 * final-bg-layer: <'background-color'> || <bg-image> || <bg-position> [ / <bg-size> ]? || <repeat-style> || <attachment> || <box> || <box>
 * // If one <box> value is present then it sets both background-origin and background-clip to that value
 */
export default function GradientPicker({ className, value, onChange }: GradientPickerProps): import("react/jsx-runtime").JSX.Element;
