/// <reference types="react" />
import { StudioIconProps } from '../public/StudioIcon';
import { ContextMenuItem } from '../../typeConfigs/components';
export interface MenuListItemActionProps {
    event: React.MouseEvent;
}
export interface MenuListItem {
    id: string;
    label: React.ReactNode;
    disabled?: boolean;
    icon?: StudioIconProps['icon'];
    className?: string;
    action?: string | ((props: MenuListItemActionProps) => void);
    classNameLabel?: string;
    items?: ContextMenuItem[];
}
export interface MenuListItemProps extends Omit<MenuListItem, 'id'> {
    active?: boolean;
    onActive?: () => void;
}
export interface MenuListProps {
    children?: React.ReactNode;
    className?: string | ((open: boolean) => string);
    handler?: React.ReactNode | ((open: boolean) => React.ReactNode);
    open?: boolean;
    sticky?: boolean;
    items: MenuListItem[];
}
export declare function MenuItem({ action, icon, label, className, items, ...rest }: MenuListItemProps): import("react/jsx-runtime").JSX.Element;
export default function MenuList({ children, items }: MenuListProps): import("react/jsx-runtime").JSX.Element;
