/// <reference types="react" />
import { InstallablePlugin } from '../../../utils/types';
export interface PluginCardProps extends Omit<React.HTMLProps<HTMLDivElement>, 'onSelect'> {
    plugin: InstallablePlugin;
    installed: InstalledMap;
    onInstall: (plugin: InstallablePlugin) => void;
    onSelect?: (plugin: InstallablePlugin) => void;
    onRemove?: (plugin: InstallablePlugin) => void;
}
type InstalledMap = Record<string, string | undefined>;
export declare const PluginCard: import("react").FunctionComponent<PluginCardProps>;
export interface PluginManagerProps {
    selectedId?: string;
}
declare const _default: import("react").FunctionComponent<PluginManagerProps>;
export default _default;
