import type PopperJS from '@popperjs/core';
import { ElementType } from 'react';
import { ButtonProps } from '../Button';
export type RenderProps = {
    close(): void;
};
export interface PopoverProps {
    handler?: React.ReactNode;
    children?: React.ReactNode | ((props: RenderProps) => void);
    title?: React.ReactNode;
    className?: string;
    classNameBody?: string;
    clickAway?: boolean;
    fixed?: boolean;
    padding?: boolean;
    border?: boolean;
    overlay?: boolean;
    placement?: PopperJS.Options['placement'];
    offset?: number[];
    canOpen?: () => boolean;
    open?: boolean;
    onClose?: () => void;
    size?: 's' | 'sm' | 'md';
    topIcon?: boolean;
    buttonAs?: ElementType<any>;
    buttonProps?: ButtonProps;
}
export default function Popover({ children, handler, title, size, padding, border, overlay, clickAway, topIcon, placement, offset, open: isOpen, onClose, buttonAs, className, classNameBody, buttonProps }: PopoverProps): import("react/jsx-runtime").JSX.Element;
