/// <reference types="react" />
export type TabOption<T extends string = string> = {
    id: T;
    label: React.ReactNode;
    content?: React.ReactNode;
    disabled?: boolean;
};
export type TabsProps<T extends string> = Omit<React.HTMLProps<HTMLDivElement>, 'onChange'> & {
    tabs: TabOption<T>[];
    value?: string;
    classNamePanel?: string;
    classNameTab?: string;
    variant?: 'pills';
    onChange?: (value: T) => void;
};
export default function Tabs<T extends string = string>({ tabs, className, classNamePanel, classNameTab, variant, style, onChange, value }: TabsProps<T>): import("react/jsx-runtime").JSX.Element;
