/// <reference types="react" />
import type { Trait, Editor, Component } from 'grapesjs';
export type CustomTraitRenderFn = (props: {
    trait: Trait;
    component: Component;
    editor: Editor;
    addEl: (el: HTMLElement) => void;
    removeEl: (el: HTMLElement) => void;
    onUpdate: (fn: () => void) => void;
}) => HTMLElement | (() => void);
export interface CustomTraitComponentProps {
    editor: Editor;
    trait: Trait;
    component: Component;
}
export type CustomTraitComponent = React.FC<CustomTraitComponentProps>;
export interface TraitCustomFieldProps extends Pick<CustomTraitComponentProps, 'editor' | 'trait'> {
}
declare const TraitCustomField: import("react").FunctionComponent<TraitCustomFieldProps>;
export default TraitCustomField;
