/// <reference types="react" />
export interface StudioIconProps {
    /**
     * If outside studio-editor, must use an SVG path definition string, like the ones imported from @mdi/js.
     * If inside studio-editor, must use an {@link IconNames}.
     */
    icon?: string | `${IconNames}` | IconNames;
    className?: string;
    size?: string | number;
    rotate?: number;
    vertical?: boolean;
    horizontal?: boolean;
}
export type Icons = Record<IconNames, string>;
export declare enum IconNames {
    alertRhombus = "alertRhombus",
    alignHorizontalCenter = "alignHorizontalCenter",
    alignHorizontalLeft = "alignHorizontalLeft",
    alignHorizontalRight = "alignHorizontalRight",
    applicationBracketsOutline = "applicationBracketsOutline",
    arrowDown = "arrowDown",
    arrowRight = "arrowRight",
    arrowULeftTop = "arrowULeftTop",
    arrowURightTop = "arrowURightTop",
    borderAllVariant = "borderAllVariant",
    borderRadius = "borderRadius",
    borderStyle = "borderStyle",
    cellphoneLink = "cellphoneLink",
    check = "check",
    checkBold = "checkBold",
    checkboxBlank = "checkboxBlank",
    chevronUp = "chevronUp",
    chevronDown = "chevronDown",
    chevronLeft = "chevronLeft",
    chevronRight = "chevronRight",
    close = "close",
    codeBraces = "codeBraces",
    cog = "cog",
    contentCopy = "contentCopy",
    contentSave = "contentSave",
    delete = "delete",
    dotsVertical = "dotsVertical",
    email = "email",
    emailOutline = "emailOutline",
    eye = "eye",
    eyedropperVariant = "eyedropperVariant",
    eyeOff = "eyeOff",
    eyeOffOutline = "eyeOffOutline",
    eyeOutline = "eyeOutline",
    fire = "fire",
    flare = "flare",
    floppy = "floppy",
    folder = "folder",
    fullscreen = "fullscreen",
    gradientVertical = "gradientVertical",
    helpCircle = "helpCircle",
    image = "image",
    information = "information",
    informationVariant = "informationVariant",
    layers = "layers",
    link = "link",
    lock = "lock",
    lockOpenVariant = "lockOpenVariant",
    menuDown = "menuDown",
    newspaperVariantOutline = "newspaperVariantOutline",
    paletteSwatch = "paletteSwatch",
    panVertical = "panVertical",
    phone = "phone",
    plus = "plus",
    plusBox = "plusBox",
    powerPlug = "powerPlug",
    refresh = "refresh",
    rhombusOutline = "rhombusOutline",
    tag = "tag",
    target = "target",
    targetVariant = "targetVariant",
    textBoxMultiple = "textBoxMultiple",
    trayArrowDown = "trayArrowDown",
    unfoldLessHorizontal = "unfoldLessHorizontal",
    unfoldMoreHorizontal = "unfoldMoreHorizontal",
    viewDayOutline = "viewDayOutline",
    viewGridPlus = "viewGridPlus",
    web = "web",
    xml = "xml",
    databaseOutline = "databaseOutline",
    databaseOutlineOn = "databaseOutlineOn",
    databaseOutlineOff = "databaseOutlineOff",
    toggleSwitchOutline = "toggleSwitchOutline",
    toggleSwitchOffOutline = "toggleSwitchOffOutline",
    codeBrackets = "codeBrackets",
    null = "null",
    codeString = "string",
    number = "number",
    mdiCloudUpload = "mdiCloudUpload"
}
export declare const defaultIcons: Icons;
declare const StudioIcon: import("react").FunctionComponent<StudioIconProps>;
export default StudioIcon;
