/// <reference types="react" />
import type { Editor } from 'grapesjs';
import type { CommonStudioLayoutConfigProps, CommonStudioLayoutProps, StudioLayoutComponentsConfig } from './types';
import { StudioLayoutMenuListConfig, StudioMenuListItemConfig } from './types/StudioMenuListSchema';
export interface StudioLayoutMenuListConfigProps extends CommonStudioLayoutConfigProps<StudioMenuListProps, StudioLayoutMenuListConfig> {
}
export interface StudioMenuListProps extends Omit<CommonStudioLayoutProps<StudioLayoutMenuListConfig>, 'children' | 'items' | 'onItemClick'> {
    items?: StudioMenuListItemProps[];
    onItemClick?: (props: OnClickEventProps) => void;
}
export interface StudioMenuListItemProps extends Omit<StudioMenuListItemConfig, 'items' | 'onClick' | 'layout'> {
    items?: StudioMenuListItemProps[];
    layout?: StudioLayoutComponentsConfig;
    onClick?: (props: OnClickEventProps) => void;
}
interface OnActionEventProps {
    event: React.MouseEvent;
}
interface OnClickEventProps extends OnActionEventProps {
    editor: Editor;
    item: StudioMenuListItemProps;
}
export declare const StudioMenuList: import("react").FunctionComponent<StudioMenuListProps>;
export default StudioMenuList;
