import { StudioLayouts } from '.';
import type { StudioLayoutFieldBaseConfig } from './StudioBaseSchema';
export declare enum ButtonGroupSize {
    m = "m",
    s = "s",
    xs = "xs"
}
export interface StudioLayoutButtonGroupFieldConfig extends StudioLayoutFieldBaseConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.buttonGroupField}`;
    /**
     * The size of the field.
     * @examples "m" | "s" | "xs"
     */
    size?: `${ButtonGroupSize}`;
    /**
     * The options for the field.
     * @example [
     *   { id: "1", label: "Username 1", title: "Username 1", icon: "<svg>...</svg>" },
     *   { id: "2", label: "Username 2", title: "Username 2", icon: "<svg>...</svg>" }
     * ]
     */
    options: [];
}
