import { StudioLayouts } from '.';
import { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutCustomConfig extends Pick<StudioLayoutBasePropsConfig, 'id' | 'className' | 'style'> {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.custom}`;
    /**
     * Component to be rendered in the custom layout.
     * @examples ({ editor }) => <button onClick={() => alert(editor.getHtml())}>Get HTML!!!</button>
     */
    component?: '__fn__';
    /**
     * Function to render the custom layout.
     * @examples ({ editor, addEl, removeEl }) => '<div>Custom layout</div>'
     */
    render?: '__fn__';
    /**
     * Indicates if the custom layout should not be wrapped (only works for React Components as the custom render needs a wrapper)
     * @default false
     */
    noWrapper?: boolean;
}
