import { StudioLayouts } from '.';
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
/**
 * Configuration for the data picker layout in Studio.
 */
export interface StudioLayoutDataVariablePickerConfig extends StudioLayoutBasePropsConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.panelDataVariablePicker}`;
    /**
     * Data variable component.
     */
    component: object;
    /**
     * Callback function to be called when the picker selection is confirmed.
     * @examples ({ value }) => console.log('new value', value);
     */
    onConfirm?: '__fn__';
}
export interface DataVariableResolverProps {
    collectionId?: string;
    variableType?: string;
    path?: string;
    defaultValue?: string;
}
