import { StudioLayouts } from '.';
import type { StudioLayoutBasePropsConfig } from './StudioBaseSchema';
export interface StudioLayoutMenuListConfig extends StudioLayoutBasePropsConfig {
    /**
     * Type of the layout component.
     */
    type: `${StudioLayouts.menuList}`;
    /**
     * The items to be displayed in the menu list.
     * @example [{ id: "item1", label: "Item 1" }, { id: "item2", label: "Item 2" }]
     */
    items: object[];
    /**
     * Global handler callback triggered once an item is clicked.
     * @example
     * onItemClick: ({ item }) => {
     *  console.log('Clicked item', { item})
     * }
     */
    onItemClick?: '__fn__';
}
export interface StudioMenuListItemConfig {
    /**
     * Unique identifier for the menu item.
     * @example "item1"
     */
    id: string;
    /**
     * The label of the menu item.
     * @example "Item 1"
     */
    label?: string;
    /**
     * Use layout components to render the label.
     * @example { type: 'column', ... }
     */
    layout?: object;
    /**
     * Whether the item is disabled.
     * @default false
     */
    disabled?: boolean;
    /**
     * The icon to be displayed next to the label.
     * @example "close"
     */
    icon?: string;
    /**
     * The CSS class name(s) for the component.
     * @example "my-component-class"
     */
    className?: string;
    /**
     * Sub-items for nested menus.
     * @example [{ id: "subitem1", label: "Sub Item 1" }, { id: "subitem2", label: "Sub Item 2" }]
     */
    items?: StudioMenuListItemConfig[];
    /**
     * Action to be performed when the item is clicked.
     */
    onClick?: '__fn__';
}
